/*						*/
/* Header files are in /usr/openwin/share/include/X11 */
/*						*/

#include "larson.h"
#include "rddata.h"
#include <time.h>
#include <sys/time.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#define	debug0(text)	printf("%s\n",text);fflush(stdout)
#define GAIN_FACTOR 9.62e-8
#define	UPDATE_INTERVAL	500	/*  target display interval in milliseconds */

#define DEFAULT_EXIT_TEXT	"Exit"
#define DEFAULT_BGCOLOR		"white"
#define DEFAULT_FGCOLOR		"black"
#define DEFAULT_BDWIDTH		1
#define DEFAULT_FONT		"fixed"
#define DEFAULT_HEIGHT	300
#define DEFAULT_WIDTH	710
#define MINHEIGHT	50

#ifdef __STDC__
int drawseismo(Display *, Window *, GC, int );
int Draw_seismo(Display *,Window ,GC ,long *,int ,char * );
int maxmin( long *, int , int *, int *);
int irint(double);
#endif
#define MAX(a,b) (((a)>(b))?(a):(b))

#ifdef __STDC__
void
rdsmplerr(int errcode,char *string)
#else
void rdsmplerr(errcode,string)
int errcode;
char *string;
#endif
{
    fprintf(stderr,"%s\n",string);
    if(errcode>12)
      exit(errcode);
}

typedef struct XRTS_PARAMS
{
    char *name;
    char **p_value_string;
}  XRTS_PARAMS;

char *mbgcolor   =	DEFAULT_BGCOLOR,
     *mfgcolor   =	DEFAULT_FGCOLOR,
     *mfont      =	DEFAULT_FONT,
     *ebgcolor   =	DEFAULT_BGCOLOR,
     *efgcolor   =	DEFAULT_FGCOLOR,
     *efont      =	DEFAULT_FONT,
     *mgeom_rsrc =	NULL,
     *extext_rsrc =	NULL,
     *display_name =	NULL,
     *extext_cline =	NULL,
     *mgeom_cline =	NULL,
     *extext       =	DEFAULT_EXIT_TEXT,
     *mgeom       =	NULL,
     *delay_string =	NULL,
     *update_string =	NULL,
     *debug_string =	NULL;

XRTS_PARAMS   resources[] = {
    {"background", &mbgcolor},
    {"forground", &mfgcolor},
    {"font", &mfont},
    {"geometry", &mgeom_rsrc},
    {"exit.background", &ebgcolor},
    {"exit.foreground", &efgcolor},
    {"exit.font", &efont},
    {"exit.text", &extext_rsrc}
};
int             num_resources = sizeof(resources) / sizeof(XRTS_PARAMS);

XRTS_PARAMS   options[] = {
    {"-display", &display_name},
    {"-d", &display_name},
    {"-geometry", &mgeom_cline},
    {"-g", &mgeom_cline},
    {"-extext", &extext_cline},
    {"-e", &extext_cline},
    {"-foreground", &mfgcolor},
    {"-delay", &delay_string},
    {"-update", &update_string},
    {"-debug", &debug_string},
};
int             num_options = sizeof(options) / sizeof(XRTS_PARAMS);

char *app_name="xrts";
XFontStruct	*mfontstruct,*efontstruct;
unsigned long	mbgpix, mfgpix, ebgpix, efgpix;
unsigned int	ewidth, eheight;
int		ey, ex, extxt, eytxt;
XWMHints	xwmh;
XSizeHints	xsh;
Display		*p_disp;
Window		Main, Exit, TimeWin,StaWin;
GC		theGC,exitGC;
XEvent		theEvent;
int		Done = 0;
char		default_geometry[80];
void usage();
int		target_delay = 0;
int		update_interval = UPDATE_INTERVAL;
int		debug = 0;

#ifdef __STDC__
int main(int argc,char *argv[])
#else
int main(argc,argv)
int argc;
char *argv[];
#endif
{
    int             i, j, Sx[NUMCOMPS], Sheight,tx,twidth,stax,stawidth;
    char           *tmpstr;
    Colormap        default_cmap;
    XColor          color;
    int             bitmask;
    XGCValues       gcv;
    XSetWindowAttributes xswa;
    Window          SWin[NUMCOMPS];
    /*	unsigned int    width, height, utemp;
	Window          wtemp; */
    char			statext[80],title_str[255],icon_ttl[255];
	

    /*    malloc_debug(2);*/
    app_name = argv[0];
    if(argc<2) {
	usage();
    }
    init_input(argv[1]);
    for (i = 2; i < argc; i += 2) {
	for (j = 0; j < num_options; j++) {
	    if (strcmp(options[j].name, argv[i]) == 0) {
		*options[j].p_value_string = argv[i + 1];
		break;
	    }
	}
	if (j >= num_options)
	  usage();
    }

    if (delay_string) target_delay = 1000 * atof(delay_string);
    if (update_string) update_interval = 1000 * atof(update_string);
    if (debug_string) debug = atoi (debug_string);
    if ((p_disp = XOpenDisplay(display_name)) == NULL) {
	fprintf(stderr, "%s: can't open display named %s\n",
		argv[0], XDisplayName(display_name));
	exit(1);
    }

    for (i =0 ; i< num_resources; i++) {
	if((tmpstr = XGetDefault(p_disp,app_name,resources[i].name)) != NULL )
	  *resources[i].p_value_string=tmpstr;
    }

    if((mfontstruct = XLoadQueryFont(p_disp, mfont)) == NULL) {
	fprintf( stderr, "%s: display %s cannot load font %s\n",
		app_name, DisplayString(p_disp), mfont);
	exit(1);
    }
    if((efontstruct = XLoadQueryFont(p_disp, efont)) == NULL) {
	fprintf( stderr, "%s: display %s cannot load font %s\n",
		app_name, DisplayString(p_disp), efont);
	exit(1);
    }

    default_cmap = DefaultColormap(p_disp,DefaultScreen(p_disp));

    if (XParseColor(p_disp,default_cmap,mbgcolor,&color) == 0 ||
	XAllocColor(p_disp,default_cmap,&color) == 0) 
      mbgpix = WhitePixel(p_disp,DefaultScreen(p_disp));
    else
      mbgpix = color.pixel;

    if (XParseColor(p_disp,default_cmap,mfgcolor,&color) == 0 ||
	XAllocColor(p_disp,default_cmap,&color) == 0) 
      mfgpix = BlackPixel(p_disp,DefaultScreen(p_disp));
    else
      mfgpix = color.pixel;

    if (XParseColor(p_disp,default_cmap,ebgcolor,&color) == 0 ||
	XAllocColor(p_disp,default_cmap,&color) == 0) 
      ebgpix = WhitePixel(p_disp,DefaultScreen(p_disp));
    else
      ebgpix = color.pixel;

    if (XParseColor(p_disp,default_cmap,efgcolor,&color) == 0 ||
	XAllocColor(p_disp,default_cmap,&color) == 0) 
      efgpix = BlackPixel(p_disp,DefaultScreen(p_disp));
    else
      efgpix = color.pixel;


    if (extext_cline != NULL) extext = extext_cline;
    else if(extext_rsrc != NULL ) extext = extext_rsrc;


    extxt = efontstruct->max_bounds.width / 2;
    eytxt = efontstruct->max_bounds.ascent + efontstruct->max_bounds.descent;
    ewidth = extxt + XTextWidth(efontstruct,extext,strlen(extext)) + 4;
    eheight = eytxt + 4;

    xsh.flags = (PPosition | PSize | PMinSize );
    xsh.height=DEFAULT_HEIGHT;
    xsh.width=DEFAULT_WIDTH;
    xsh.min_height = MINHEIGHT;
    xsh.width = MAX(xsh.width,ewidth);
    xsh.min_width = xsh.width;
    xsh.x = (DisplayWidth(p_disp, DefaultScreen(p_disp)) - xsh.width) /2;
    xsh.y = (DisplayHeight(p_disp, DefaultScreen(p_disp)) - xsh.height) /2;
    sprintf(default_geometry, "%dx%d+%d+%d",
	    xsh.width, xsh.height, xsh.x, xsh.y);
    mgeom = default_geometry;

    if(mgeom_cline != NULL ) mgeom = mgeom_cline ;
    else if( mgeom_rsrc != NULL ) mgeom = mgeom_rsrc;

    bitmask = XGeometry(p_disp, DefaultScreen(p_disp), mgeom, default_geometry,
			DEFAULT_BDWIDTH, mfontstruct->max_bounds.width, 
			mfontstruct->max_bounds.ascent + 
			mfontstruct->max_bounds.descent, 
			1, 1, &(xsh.x), &(xsh.y), &(xsh.width), &(xsh.height));
    if(bitmask & (XValue | YValue )) xsh.flags |= USPosition;
    if(bitmask & (WidthValue | HeightValue )) xsh.flags |=USSize;


    Main = XCreateSimpleWindow(p_disp, DefaultRootWindow(p_disp),
			       xsh.x, xsh.y, xsh.width, xsh.height, 
			       DEFAULT_BDWIDTH, mfgpix, mbgpix);

    sprintf(title_str,"Real-time seismograph for %s",argv[1]);
    sprintf(icon_ttl,"XrtS: %s",argv[1]);
    XSetStandardProperties(p_disp,Main,title_str,icon_ttl,None,argv,argc,&xsh);

    xwmh.flags = (InputHint | StateHint );
    xwmh.input = False;
    xwmh.initial_state = NormalState;
    XSetWMHints(p_disp,Main, &xwmh);

    gcv.font = mfontstruct->fid;
    gcv.foreground = mfgpix;
    gcv.background = mbgpix;
    theGC = XCreateGC(p_disp, Main, (GCFont|GCForeground|GCBackground ), &gcv);

    xswa.colormap = DefaultColormap(p_disp,DefaultScreen(p_disp));
    xswa.bit_gravity = CenterGravity;
    XChangeWindowAttributes(p_disp, Main, (CWColormap | CWBitGravity), &xswa);
    
    XSelectInput(p_disp, Main, ExposureMask | ResizeRedirectMask);

    XMapWindow(p_disp,Main);


    ex = 1;
    ey = 1;
    Exit = XCreateSimpleWindow(p_disp, Main, ex, ey, ewidth, eheight, 
			       DEFAULT_BDWIDTH, efgpix, ebgpix);
    XSelectInput(p_disp, Exit, ExposureMask | ButtonPressMask);
    XMapWindow(p_disp, Exit);
	
    stax=ex+ewidth;
    sprintf(statext,"Station: %s",argv[1]);
    stawidth=extxt+XTextWidth(efontstruct,statext,strlen(statext))+4;
    StaWin = XCreateSimpleWindow(p_disp, Main, stax, ey, stawidth, eheight, 
				 DEFAULT_BDWIDTH, efgpix, ebgpix);
    XSelectInput(p_disp, StaWin, ExposureMask);
    XMapWindow(p_disp, StaWin);
    tx=stax+stawidth;
    twidth=xsh.width-tx-3;
    TimeWin = XCreateSimpleWindow(p_disp, Main, tx, ey, twidth, eheight, 
				  DEFAULT_BDWIDTH, efgpix, ebgpix);
    XSelectInput(p_disp, TimeWin, NoEventMask);
    XMapWindow(p_disp, TimeWin);

    Sx[0]=eheight+ey+2;
    Sheight=(xsh.height-Sx[0]-8)/NUMCOMPS;
    Sx[1]=Sx[0]+Sheight+2;
    Sx[2]=Sx[1]+Sheight+2;
    for (i = 0; i < NUMCOMPS; i++) {
	SWin[i] = XCreateSimpleWindow(p_disp, Main, 1,Sx[i],xsh.width-2, 
				      Sheight,0, mfgpix, mbgpix);
	XSelectInput(p_disp, SWin[i], NoEventMask );
	XMapWindow(p_disp,SWin[i]);
    }

    gcv.font = efontstruct->fid;
    gcv.foreground = efgpix;
    gcv.background = ebgpix;

    exitGC = XCreateGC(p_disp, Exit, (GCFont|GCForeground|GCBackground), &gcv);

    while (!Done) {
	if (XPending(p_disp) > 0) {
	    XNextEvent(p_disp, &theEvent);
	    if (theEvent.xany.window == Exit) {
		switch (theEvent.type) {
		  case Expose:
		    debug0("Expose for Exit event");
		    if (theEvent.xexpose.count == 0) {
			XClearWindow(p_disp, Exit);
			XDrawString(p_disp, Exit, exitGC, extxt, eytxt, extext,
				    strlen(extext));
			XFlush(p_disp);
		    }
		    break;
		  case ButtonPress:
		    Done = 1;
		}
	    }
	    if (theEvent.xany.window == StaWin) {
		switch (theEvent.type) {
		  case Expose:
		    debug0("Expose for StaWin event");
		    if (theEvent.xexpose.count == 0) {
			XClearWindow(p_disp, StaWin);
			XDrawString(p_disp, StaWin, exitGC, extxt, eytxt, 
				    statext, strlen(statext));
			XFlush(p_disp);
		    }
		    break;
		  case ButtonPress:
		    Done = 1;
		}
	    }
	    /*
	    if (theEvent.xany.window == Main) {
		if (theEvent.type == ResizeRequest) {
		    debug0("ResizeRequest event");
		    if (XGetGeometry(p_disp, Main, &wtemp, &itemp, &itemp, 
				     &width, &height, &utemp, &utemp) == 0)
		      exit(1);
		    Sx[0] = eheight + ey + 2;
		    Sheight = (height - Sx[0]) / NUMCOMPS - 8;
		    Sx[1] = Sx[0] + Sheight + 2;
		    Sx[2] = Sx[1] + Sheight + 2;
		    for(i=0;i<NUMCOMPS;i++)
		      XMoveResizeWindow(p_disp, SWin[i], 1, Sx[i],width-2, 
					Sheight);
		}
	    }
	    */
	} else {
	    drawseismo(p_disp, SWin, theGC, xsh.width);
	}

    }

    XFreeGC(p_disp,theGC);
    XFreeGC(p_disp,exitGC);
    XDestroyWindow(p_disp,Main);
    XCloseDisplay(p_disp);
    exit(0);
}

void 
usage()
{
	fprintf(stderr, "usage: %s station_name [-delay n][-update f] [-display host:display] [-geometry geom] [-extext text]\n", app_name);
	exit(1);
}


#define SAMPDISPRATE 25
#ifdef __STDC__
int
drawseismo(Display * tdisp, Window * tWins, GC tGC, int points)
#else
int
drawseismo(tdisp, tWins, tGC, points)
     Display        *tdisp;
     Window         *tWins;
     GC              tGC;
     int             points;
#endif
{
    int             i, j, newlen=0, itemp;
    long stime1,smsec1;
    static long     compdata[NUMCOMPS][1500], stime, smsec, delt;
    static int	    sampdisprate;
    static char     run_before = LARSON_FALSE;
    ldiv_t ldivtemp;
    char outstr[155],outstr2[63];
    struct timeval t;
    int diff;
    int csec, cmsec;

    if (run_before == LARSON_FALSE) {
	run_before = LARSON_TRUE;
	read_next_sample(1, &compdata[0][0], &compdata[1][0], &compdata[2][0],
			 &stime1, &smsec1);
	read_next_sample(1, &compdata[0][0], &compdata[1][0], &compdata[2][0],
			 &stime, &smsec);
	delt=smsec-smsec1;
	if (delt <= 0) delt += 1000;
	sampdisprate = update_interval / delt;
	if (sampdisprate <= 0) sampdisprate = 1;
	for (j = 0; newlen < points;) {
	    itemp = sampdisprate * j;
	    if (read_next_sample(sampdisprate, &compdata[0][itemp], 
				 &compdata[1][itemp], &compdata[2][itemp], 
				 &stime, &smsec) < 0)
	      continue;
	    newlen = sampdisprate * ++j - 1;
/*
	    for (i = 0; i < NUMCOMPS; i++)
	      Draw_seismo(tdisp, tWins[i], tGC, compdata[i], newlen, 
			  statchan[i]);
	    XFlush(p_disp);
*/
	}
	for (j = 0; j < NUMCOMPS; j++)
	  for (i = 0; i < points; i++)
	    compdata[j][i] = compdata[j][i + newlen-points];
	ldivtemp = ldiv (smsec,1000);
	stime += ldivtemp.quot;
	smsec = ldivtemp.rem;
    }
    while (XPending(p_disp) == 0) {
	for (j = 0; j < NUMCOMPS; j++)
	  for (i = 0; i < points - sampdisprate; i++)
	    compdata[j][i] = compdata[j][i + sampdisprate];
	itemp = points - sampdisprate;
	while (read_next_sample(sampdisprate, &compdata[CHAN0][itemp], 
				&compdata[CHAN1][itemp], 
				&compdata[CHAN2][itemp], &stime, &smsec) < 0);
	do {
	    gettimeofday(&t,NULL);
	    csec = t.tv_sec;
	    cmsec = t.tv_usec/1000;
	    diff = (csec - stime)*1000 + cmsec - smsec;
	    if (diff < 0) {
		if (target_delay > 0) {
		    printf ("Warning - clocks not aligned.  Setting delay to 0\n");
		    target_delay = 0;
		}
		diff = 0;
	    }
	    if (diff > 0 && diff < target_delay) 
	    {
              struct timespec thistime;
	      unsigned int sleeptime = target_delay - diff;
	      if (debug) 
	      {
		    printf ("curtime = %d %d stime = %d %d, diff = %d msec\n",
			    csec, cmsec, stime, smsec, diff);
		    printf ("sleeping for %d msecs\n", sleeptime);
	      }
              thistime.tv_sec = (time_t) (sleeptime*10000);
              thistime.tv_nsec = 0;
	      nanosleep(&thistime,NULL);
	      diff += sleeptime;
	      continue;
	    }
	    else diff = target_delay;
	} while (diff < target_delay);
	for (i = 0; i < NUMCOMPS; i++)
	  Draw_seismo(tdisp, tWins[i], tGC, compdata[i], points, statchan[i]);
	ldivtemp=ldiv(smsec+delt*sampdisprate,1000);
	stime+=ldivtemp.quot;
	smsec = ldivtemp.rem;
	strftime(outstr,80,"Last Sample: %a %h %e, %Y %T",gmtime(&stime));
	strftime(outstr2,80,"Local Time: %T",localtime(&stime));
	sprintf(outstr,"%s.%03ld GMT  %s.%03ld  Window length: %.2fs",
		outstr,smsec,outstr2,smsec,
		(float)delt*points/1000.0);
	XClearWindow(tdisp,TimeWin);
	XDrawString(tdisp,TimeWin,tGC,extxt,eytxt,outstr,strlen(outstr));
	XFlush(p_disp);	/* debug */
    }
    return 0;
}
#ifdef __STDC__
int
Draw_seismo(Display * tdisp, Window tWin, GC tGC, long *data, int points, char *text)
#else
int
Draw_seismo(tdisp, tWin, tGC, data, points, text)
	Display        *tdisp;
	Window          tWin;
	GC              tGC;
	long           *data;
	int		points;
	char           *text;
#endif
{
	int             maxim, min, i, j,*temp,itemp;
	float           yscale, zero_offset, xscale;
	unsigned int    width, height, utemp;
	Window          wtemp;
	char outstr[80];

	if (XGetGeometry(tdisp, tWin, &wtemp, &itemp, &itemp, &width,
			 &height, &utemp, &utemp) == 0)
		exit(1);
	temp = (int *) calloc(width, sizeof(int));
	maxmin(data, points, &maxim, &min);
	sprintf(outstr,"%s  Range: %e",text,(maxim-min)*GAIN_FACTOR);
	yscale = ((float) (height - 2) / (maxim - min));
	xscale = (float) points / width;
	zero_offset = 1 + yscale * maxim;
	for (i = 0; i < width; i++) {
		j = irint(i * xscale);
		temp[i] = irint(-data[j] * yscale + zero_offset);
	}
	XClearWindow(tdisp,tWin);
	for (i = 1; i < width - 2; i++)
		XDrawLine(tdisp, tWin, tGC, i, temp[i], i + 1, temp[i + 1]);
	XDrawString(tdisp, tWin, tGC, 0, 10, outstr, strlen(outstr));
	free(temp);
	return 0;
}

#ifdef __STDC__	
int 
maxmin(long *array, int arrlen, int *maxim, int *min)
#else
int 
maxmin(array,arrlen,maxim,min)
long *array;
int arrlen, *maxim, *min;
#endif
{
	int             i;

	*maxim = array[0];
	*min = array[1];
	for (i = 1; i < arrlen; i++) {
		if (array[i] > *maxim)
			*maxim = array[i];
		if (array[i] < *min)
			*min = array[i];
	}
	if(*min==*maxim)
		return 1;
	else
		return 0;
}

