#include "Epackets.h"
const char      disk_file[] = "file_list";

fp             fp_data;

DATA_HDR *
get_packet(unsigned char * indata)
{
	int             nr;
	int		blksize = 0;
	DATA_HDR	*hdr;
	BS		*bs;
	BLOCKETTE_HDR	*bh;

	/* Read minimal amount of data, and determine blksize.		*/
	/* Read enough so that we should have all blockettes, but no	*/
	/* more than the minimal blksize.				*/

	nr = fread(indata, MIN_BLKSIZE ,1,fp_data);
	if(feof(fp_data)) {
		printf("End of file reached\n");
		exit(0);
	}
	if ((hdr = decode_hdr_sdr ((SDR_HDR *)indata, &blksize)) == NULL) {
		fprintf (stderr, "Error decoding SEED data hdr\n");
		exit(1);
	}
	if (blksize > MIN_BLKSIZE) {
	    nr = fread (indata + MIN_BLKSIZE, blksize-MIN_BLKSIZE, 1, fp_data);
	    if (feof(fp_data)) {
		fprintf (stderr, "Error reading SEED data\n");
		exit(1);
	    }
	}
	/* Fill in the number of data frames.   */
	if ((bs = find_blockette(hdr,1001)) &&
		(bh = (BLOCKETTE_HDR *)(bs->pb))) 
		hdr->num_data_frames = ((BLOCKETTE_1001 *)bh)->frame_count;
	else hdr->num_data_frames =
		(hdr->sample_rate == 0) ? 0 :
		(blksize - hdr->first_data) / sizeof(FRAME);

	return (hdr);
}

int
init_input(char *station)
{
	char            errstr[255], filename[127], tstation[15],tempstr[255];
	fp              fp_files;
	int             found = FALSE;

	/* Get file name from file */
	efopen(disk_file, "r", fp_files);
	while (!feof(fp_files)) {
		fgets(tempstr, 255, fp_files);
		sscanf(tempstr, "%s%s", tstation, filename);
		if (strcmp(station, tstation) == 0) {
			found = TRUE;
			break;
		}
	}
	fclose(fp_files);
	if (found == FALSE) {
		sprintf(errstr,"Station not found in file: %s\n",disk_file);
		rdsmplerr(243,errstr );
	}
	efopen(filename,"r",fp_data);
	return 0;
}

