/***********************************************************

File Name :
	tvmag.C

Programmer:
	Phil Maechling

Description:
	This is the terravision magnitude program.
	
Creation Date:
	9 September 1995

Modification History:


Usage Notes:

	SYNTAX: tvmag <remote-node> 
	Note that error messages can be read from the socket by this
	client.

**********************************************************/
#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <unistd.h>
#include "basics.h"
#include "rpttbl.h"
#include "opensocket.h"
#include "solution.h"
#include "syserr.h"
#include "tvmag.h"
#include "final.h"
#include "network_mag.h"
#include "summarize.h"
#include "scan_sol.h"

const int TRYING_TO_CONNECT = TRUE;
const int SIZE_OF_SOLUTION_MESSAGE = 112;
const int FILE_LINE_LENGTH = 81;
const int FINAL = 9;

float minpagemag; // extern so paging routines can see it


int main(int argc, char *argv[])
{
  int 	 socket_channel;
  int	 status;
  int    magstatus;
  char	 string_in[SIZEOF_PACKET_BUFFER];
  char   line[FILE_LINE_LENGTH];
  char   sta[STATION_NAME_SIZE];

  struct station_list_type stalist; 
  struct solution_type sol;

  float  latitude,longitude;
  int res;

  //
  // Start of code
  //

  if (argc < 2) 
  {
    cout << " SYNTAX: tvmag <remote-node>" <<endl ;	
    exit (0);
  } 
  else 
  { 
    cout << "The remote node    is: " << argv[1] << endl;
    cout << "The remote service is: " << "hyp_server" << endl;
  }

  /* Read minimum and paging magnitude from a file */

  FILE  *fp;
  float mincalcmag; 

  fp = fopen(MINMAGFILE,"r");
  if(fp == NULL)
  {
    syserr("Error opening Min Mag file");
    mincalcmag  = 0.0;
    minpagemag  = 3.5;
  }
  else
  {
    res = fscanf(fp,"%f %f",&mincalcmag,&minpagemag);
    if (res !=2)
    {
      syserr("Error scanning Min Mag file");
      mincalcmag  = 0.0;
      minpagemag  = 3.5;
    }
    fclose(fp);
  }


  cout << "Minimum event magnitude that TERRAvision will update is : " << 
    (float) mincalcmag << endl;
  cout << "Minimum TERRAvision magnitude to page is : " <<
    (float) minpagemag << endl;

  fflush(stdout);

  //
  // Clear the finalized event array
  //

  clear_event_array();

  //
  // Read in the station list
  //

  fp = fopen(TVMAG_STATION_LIST,"r");
  if (fp == NULL)
  {
    report_trouble("tvmag");
    sleep(60);
    report_trouble("tvmag");
    sleep(60);
    report_trouble("tvmag");
    fatalsyserr("TVMAG_STATIONS_LIST file open failed in tvmag.");
  }
 
  stalist.number_of_stations = 0;

  float v2c,amlcor,vbbgain,lggain;
 
  while (fgets(line,FILE_LINE_LENGTH,fp) != NULL)
  {
    status = sscanf(line,"%s %f %f %f %f %f %f",&sta,&latitude,&longitude,
			&v2c,&amlcor,&vbbgain,&lggain);
    if(status != 7)
    {
      fclose(fp);
      report_trouble("tvmag");
      sleep(60);
      report_trouble("tvmag");
      sleep(60);
      report_trouble("tvmag");
      fatalsyserr("Scanf error reading stations list in tvmag.");
    }
 
    memcpy(&stalist.station_data[stalist.number_of_stations].
		input_data.station_name,
                sta,STATION_NAME_SIZE);

    stalist.station_data[stalist.number_of_stations].input_data.
      latitude = latitude;

    stalist.station_data[stalist.number_of_stations].input_data.
      longitude = longitude;

    stalist.station_data[stalist.number_of_stations].input_data.
      v2c = v2c;

    stalist.station_data[stalist.number_of_stations].input_data.
      amlcor = amlcor;

    stalist.station_data[stalist.number_of_stations].input_data.
      vbbgain = vbbgain;

    stalist.station_data[stalist.number_of_stations].input_data.
      lggain = lggain;

    stalist.number_of_stations++;

  }

  fclose(fp);

  while (TRYING_TO_CONNECT)
  {

    /* Open the socket connection */

    status = open_socket(argv[1],		
               	         "hyp_server",
               	         &socket_channel);

    if (status != SUCCESS) 
    {
      cout << "Error on open_socket call. " << endl;
      sleep(30);
      report_trouble("tvmag");
      continue;
    }

    /*   Reading socket to get hypo_centers
     *   status == 0 indicates end-of-file (socket closed by remote), else its 
     *   the number of bytes received
    */
    
    while ((status = get_msg(&socket_channel, (char *) &string_in)) > 0)
    {

      if (status < SIZE_OF_SOLUTION_MESSAGE)
      {
        // Ignore alive messages
        continue;
      }
      else
      {
        cout << endl;
        cout << "Read Status : " << status << endl;
        cout << "Msg         : "  << string_in << endl;
        fflush(stdout);

        res = sscanf(string_in,
        "%*s %d %d %d %d %d %d %f %f %f %f %f %d %d %d %f %s %s %f %d %s %d",
        &sol.event_id,
	&sol.year,&sol.month,&sol.day,&sol.hour,&sol.minute,&sol.seconds,
	&sol.latitude,&sol.longitude,&sol.depth,
        &sol.solution_rms,&sol.solution_phases,&sol.solution_version,
        &sol.solution_status,
        &sol.magnitude,sol.magnitude_type,sol.magnitude_method,
	&sol.magnitude_rms,&sol.stations_in_magnitude,
        sol.solution_source,&sol.solution_count);
        
        if (res != 21)
        {
          cout << "Using Secondary scan of solution message." << endl;
	  res = scan_solution_message(sol,string_in);
          if (res != SUCCESS)
          {
            cout << "Error scanning solution message." << endl;
            cout << "CHECK THIS ERROR " << endl;
            //report_trouble("tvmag");
            sleep(5);
            continue;
          }
        } 
      }

      //
      // At this point we have the data in a solution structure 
      // Check if the magnitude is greater than minimum mag.
      //
      
 
      if((sol.magnitude >= mincalcmag) && 
         (sol.solution_status == FINAL) &&
         (!event_was_finalized(sol))     )
      {
        
         update_event_check_locations(sol);

         // 
         // Pass large structures by reference 
         //

         magstatus = network_magnitude(sol,stalist);

         if(magstatus == SUCCESS)
         {
           summarize_results(sol,stalist);
           make_event_final(sol);
         }
         else
         {
           cout << "Magnitude Calculation FAILED for event :" << 
             sol.event_id << endl;
         }

      }// This is end of calculation processing. 
       // Loop back from here to read another solution.

    }// This is end point for read socket.Pass this point and you
     // must reconnect to hyp_server.

    cout << "Error returned from socket read : " << status << endl;
    close(socket_channel);
    report_trouble("tvmag");
    sleep(30);
  } 
  return(SUCCESS);
}
