/***********************************************************

File Name :
	summarize.h

Programmer:
	Phil Maechling

Description:
	This takes results from a magnitude calculation and
	summarizes the results. It will generate email and pages
	with the summary information.

Creation Date:
	14 September 1995

Modification History:


Usage Notes:


**********************************************************/
#ifndef summarize_H
#define summarize_H

#include "basics.h"
#include "solution.h"
#include "network_mag.h"


struct network_mag_summary_type
{
  int   number_of_stations_used;
  char  station_name[MAX_STATIONS_IN_NETWORK][STATION_NAME_SIZE];
  int   sensor_type[MAX_STATIONS_IN_NETWORK];
  float ml[MAX_STATIONS_IN_NETWORK];
  float me[MAX_STATIONS_IN_NETWORK];
  float network_ml;
  float ml_rms;
  float network_me;
  float me_rms;
};

void make_summary_report(struct station_list_type& stalist,
			struct solution_type& sol,
		        struct network_mag_summary_type& netmags);

int summarize_results(struct solution_type&     sol, 
		      struct station_list_type& stalist);

void summarize_network_results(struct station_list_type& stalist,
			       struct network_mag_summary_type& netmags);

void add_event_to_catalog(struct solution_type& sol);

void update_event_check_magnitudes(struct solution_type& sol,
	                           struct network_mag_summary_type& netmags);

void make_magbid(struct solution_type& sol,
	         struct network_mag_summary_type& netmags);

void send_pages(struct solution_type& sol,
		struct network_mag_summary_type& netmags);

void netmag_to_belt_summary_page(struct network_mag_summary_type& netmags,
				 int event_id,
			         char* page);

void update_event_check_locations(struct solution_type& sol);


int pick_vbb_or_lg(struct station_data_type& sta);


int use_station(struct station_data_type& sta);


#endif
