/***********************************************************

File Name :
	stream_mag.h

Programmer:
	Phil Maechling

Description:
	Header file for a stream magnitude program.
	It should accept vbb or lg data, and calculate
	a magnitude from it.

Creation Date:
	12 September 1995

Modification History:


Usage Notes:

	This code assumes that 15 seconds of time series must be
	available for a least one component. Otherwise, a
	fatal errror is returned and not mag is calculated.

**********************************************************/
#ifndef stream_mag_H
#define stream_mag_H

#ifdef __cplusplus
extern "C"
{
stream_magnitude_(
        float* v2c,
        float* amlcor,
	float* tvbgain,
	float* tlggain,
	int* iyy,int* iday,int* ihr,int* imin,int* isec,
	float* distance,float* depth,
	int* sensor_type,
        int* sps,
	int* zarr,
	int* narr,
	int* earr,
	int* syr,int* sday,int* shr,int* smin,int* ssec,
	int* spts,
	int* rferror,
	int* rcerror,
	int* rclip,
	int* rupdate,
	int* rzerr,int* rnerr,int* reerr,
	float* rmlz,float* rmln,float* rmle,
	float* ramlav,float* renmag);
}
#else

stream_magnitude_(
        float* v2c,
        float* amlcor,
	float* tvbgain,
	float* tlggain,
	int* iyy,int* iday,int* ihr,int* imin,int* isec,
	float* distance,float* depth,
	int*  sensor_type,
        int* sps,
	int* zarr,
	int* narr,
	int* earr,
	int* syr,int* sday,int* shr,int* smin,int* ssec,
	int* spts,
	int* rferror,
	int* rcerror,
	int* rclip,
	int* rupdate,
	int* rzerr,int* rnerr,int* reerr,
	float* rmlz,float* rmln,float* rmle,
	float* ramlav,float* renmag);
#endif
#endif
