c
c	File: stream_mag.f
c
c       Executable: tem routines
c
c	Purpose:
c         This program inputs and event time, and location, and
c	  instrument type.
c
c	  Given that, the program return a magnitude figure for the
c	  stream.
c
c	Programmer:
c         Phil Maechling
c
c	Last Modifications:
c         19 May 1994
c
c	Limitions:
c
c	This code assumes that 15 seconds of time series must be
c	available for a least one component. Otherwise, a
c	fatal errror is returned and not mag is calculated.
c
c	Also, it assumes that any component with less that 15
c	seconds of time series is invalid. It zeros the component
c	so no result will be returned for it from engymagr.
c
c	
c	Filename etc are always 80 characters
c	Counts are limited to MAX_SAMPLES
c	Stations names are set at 5 but checked at 3
c
c------------------------------------------------------------------
c
c Inputs:
c
c iyy : event date and time
c dist  : distance to event
c depth : event depth as a positive number
c snsrtyp : 0 = VBB 1 = LG (see terramag.inc
c
c
c
c Outputs :
c
c rferror  : 1 = fatal error
c rcerror  : 1 = error with one or more components
c rclip    : 1 = signal clipped
c rupdate  : 1 = updatae needed with more samples
c rzerr..  : 1 = error with that component
c rmlz     : ml for z component
c rmln     : ml for n component
c rmle     : ml for e component
c ramlav   : station ml magnitude
c renmag   : station me magnitude
c

        subroutine stream_magnitude(
	2 v2c,
	2 amlcor,
	2 tvbgain,
	2 tlggain,
	2 iyy,iday,ihr,imin,isec,
	2 dist,depth,
	2 snsrtyp,
	2 sps,
	2 zarr,
	2 narr,
	2 earr,
	2 syr,sday,shr,smin,ssec,
	2 spts,
	2 rferror,
	2 rcerror,
	2 rclip,
	2 rupdate,
	2 rzerr,rnerr,reerr,
	2 rmlz,rmln,rmle,
	2 ramlav,renmag)

c
c This include file defines the max number of samples in a time series
c

	include '/home/phil/da/pjlib/terramag.inc'
c
c
c Define timeseries variables
c
	integer zarr(18000)
	integer narr(18000)
	integer earr(18000)
	integer spts(3)
   	integer syr(3),sday(3),shr(3),smin(3),ssec(3)
	integer sps
	integer snsrtyp
c
c
c
c
	real v2c,amlcor,tvbgain,tlggain
	integer iyy,iday,ihr,imin,isec
	real dist
	real depth, pdepth
	real  dt
	integer idt
	integer nd(3)

c
c
c Stream mag return values
c
c
	integer rferror,rcerror,rzerr,rnerr,reerr
	integer rclip,rupdate
	real rmlz,rmln,rmle,ramlav,renmag
c
c Time handling variables for the file naming routine
c
	integer imaxts
c
c Call and return variables for engymagr program
c
	integer tsyear(3),tsday(3),tshour(3),tsmin(3),tssec(3)
c
c
c Define arrays to hold the time series
c
c
	real     pt(3,MAX_SAMPLES_IN_SERIES)
c
c Start of program code
c
c Set returned variables to zero
c
	rferror = 0
	rcerror = 0
	rzerr = 0
	rnerr = 0
	reerr = 0
	rclip  = 0
	rupdate = 0
c
c Zero the real numbers
c
	rmlz = 0.0
	rmln = 0.0
	rmle = 0.0
	ramlav = 0.0
	renmag = 0.0

c
c Convert depth to positive real. and longitude to positive
c  real number
c

	pdepth  = (-1.0) * depth

c
c Transfer the input data to the working locations
c
	do 445 icnt=1,3

	tsyear(icnt) = syr(icnt)
	tsday(icnt)  = sday(icnt)
        tshour(icnt) = shr(icnt)
	tsmin(icnt)  = smin(icnt)
        tssec(icnt)  = ssec(icnt)

	do 444 idpts=1,spts(icnt)

          if(icnt.eq.1) then
	    pt(icnt,idpts) = zarr(idpts)
          elseif(icnt.eq.2) then
	    pt(icnt,idpts) = narr(idpts)
          else
	    pt(icnt,idpts) = earr(idpts)
	  endif

444    	continue
445	continue
c
c  Set up the nd 
c
	nd(1) = spts(1)
	nd(2) = spts(2)
	nd(3) = spts(3)	

c
c use the parameters to set the sample rate and the frequency
c
	idt = sps
	dt = 1.0/float(idt)
c
c Find the smallest number of samples in any of the components
c
	imaxts = spts(1)
	do 199 i=1,3
  	  itmp = spts(i)
          if (itmp .gt. imaxts) then
	    imaxts = itmp
          end if
199 	continue
c
c
c Determine number of samples in 15 seconds of time series
c
	minsamp = 15 * idt
c
c
c First test if any have more than 15 seconds of time series
c
c
        if (imaxts .lt. minsamp ) then
	  rferror = 3 
	  return
        end if
c
c
c Now check each component. Set component sample count to zero if
c	it is less than 15 seconds of data.
c

  	do 103 i = 1,3
	  if (spts(i).lt.minsamp) then
	    spts(i) = 0
	  endif
103	continue

c
c
c engymag uses lat, long, and depth  positive
c   and sample rate in seconds per sample
c
c Find the magnitude
c
c

	  call engymagr(
	2 v2c,amlcor,tvbgain,tlggain,
	2 iyy,iday,ihr,imin,isec,
	2 dist,pdepth,
	2 tsyear,tsday,tshour,tsmin,tssec,
	2 snsrtyp,
	2 dt,
	2 nd,
	2 pt,
	2 rferror,
	2 rcerror,
	2 rclip,
	2 rupdate,
	2 rzerr,rnerr,reerr,
	2 rmlz,rmln,rmle,
	2 ramlav,renmag)
c
c All returned results are passed through to caller
c

	return

500	continue
	write(*,*) 'Too many samples in time series'
	close(15)
	rferror = 1
	return

	end

