/***********************************************************

File Name :
	scan_sol.C

Programmer:
	Phil Maechling

Description:
	Sometimes the primary scan of solution messages fails
	because all fields are not space delimited.
	This is a fixed format scan routine, which attemps
	to populate the solution structure.

Creation Date:
	14 September 1995

Modification History:


Usage Notes:


**********************************************************/
#include <string.h>
#include <stdlib.h>

#include "basics.h"
#include "solution.h"

int scan_solution_message(struct solution_type& sol,char* input_string)
{
  char tempbuf[10];
  int curchar;

  //
  // Event ID
  //
  curchar = 8;
  memset(tempbuf,0,sizeof(tempbuf));
  strncpy(tempbuf,&input_string[curchar],7);
  sol.event_id = atoi(tempbuf);

  //
  // Year
  // 
  curchar = 16;
  memset(tempbuf,0,sizeof(tempbuf));
  strncpy(tempbuf,&input_string[curchar],4);
  sol.year = atoi(tempbuf);

  //
  // Month
  // 
  curchar = 21;
  memset(tempbuf,0,sizeof(tempbuf));
  strncpy(tempbuf,&input_string[curchar],2);
  sol.month = atoi(tempbuf);

  //
  // Day
  // 
  curchar = 24;
  memset(tempbuf,0,sizeof(tempbuf));
  strncpy(tempbuf,&input_string[curchar],2);
  sol.day = atoi(tempbuf);

  //
  // Hour
  // 
  curchar = 27;
  memset(tempbuf,0,sizeof(tempbuf));
  strncpy(tempbuf,&input_string[curchar],2);
  sol.hour = atoi(tempbuf);

  //
  // Minute
  // 
  curchar = 30;
  memset(tempbuf,0,sizeof(tempbuf));
  strncpy(tempbuf,&input_string[curchar],2);
  sol.minute = atoi(tempbuf);

  //
  // Second
  // 
  curchar = 33;
  memset(tempbuf,0,sizeof(tempbuf));
  strncpy(tempbuf,&input_string[curchar],5);
  sol.seconds = (float) atof(tempbuf);

  //
  // Latitude
  // 
  curchar = 39;
  memset(tempbuf,0,sizeof(tempbuf));
  strncpy(tempbuf,&input_string[curchar],7);
  sol.latitude = (float) atof(tempbuf);

  //
  // Longitude
  // 
  curchar = 47;
  memset(tempbuf,0,sizeof(tempbuf));
  strncpy(tempbuf,&input_string[curchar],9);
  sol.longitude = (float) atof(tempbuf);

  //
  // Depth
  //
  curchar = 57;
  memset(tempbuf,0,sizeof(tempbuf));
  strncpy(tempbuf,&input_string[curchar],6);
  sol.depth = (float) atof(tempbuf);

  //
  // solution rms
  //
  curchar = 64;
  memset(tempbuf,0,sizeof(tempbuf));
  strncpy(tempbuf,&input_string[curchar],4);
  sol.solution_rms = (float) atof(tempbuf);

  // 
  // Number of phases
  //
  curchar = 69;
  memset(tempbuf,0,sizeof(tempbuf));
  strncpy(tempbuf,&input_string[curchar],3);
  sol.solution_phases = atoi(tempbuf);

  //
  // Solution Version
  //
  curchar = 73;
  memset(tempbuf,0,sizeof(tempbuf));
  strncpy(tempbuf,&input_string[curchar],2);
  sol.solution_version = atoi(tempbuf);
 
  //
  // Solution Status
  //
  curchar = 76;
  memset(tempbuf,0,sizeof(tempbuf));
  strncpy(tempbuf,&input_string[curchar],2);
  sol.solution_status = atoi(tempbuf);

  //
  // Magnitude
  //
  curchar = 79;
  memset(tempbuf,0,sizeof(tempbuf));
  strncpy(tempbuf,&input_string[curchar],4);
  sol.magnitude = (float) atof(tempbuf);

  //
  // Magnitude Type
  //
  curchar = 84;
  memset(tempbuf,0,sizeof(tempbuf));
  strncpy(sol.magnitude_type,&input_string[curchar],3);

  //
  // Magnitude Method
  //
  curchar = 88;
  memset(tempbuf,0,sizeof(tempbuf));
  strncpy(sol.magnitude_method,&input_string[curchar],4);

  //
  // Magnitude RMS
  //
  curchar = 93;
  memset(tempbuf,0,sizeof(tempbuf));
  strncpy(tempbuf,&input_string[curchar],5);
  sol.magnitude_rms = (float) atof(tempbuf);

  //
  // Magnitude number of stations
  //
  curchar = 99;
  memset(tempbuf,0,sizeof(tempbuf));
  strncpy(tempbuf,&input_string[curchar],3);
  sol.stations_in_magnitude = atoi(tempbuf);

  //
  // Magnitude Source
  //
  curchar = 103;
  memset(tempbuf,0,sizeof(tempbuf));
  strncpy(sol.solution_source,&input_string[curchar],3);

  //
  // Solution Count
  //
  curchar = 107;
  memset(tempbuf,0,sizeof(tempbuf));
  strncpy(tempbuf,&input_string[curchar],5);
  sol.solution_count = atoi(tempbuf);

  return(SUCCESS);
}
