/***********************************************************

File Name :
	opensocket.C

Programmer:
	Phil Maechling

Description:
	These are basic socket routines used by the terravision
	magnitude program.
	
Creation Date:
	9 September 1995

Modification History:


Usage Notes:

	Note that error messages can be read from the socket by this
	client.

**********************************************************/

#include <iostream.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include "basics.h"

#include <ctype.h>			/* or 'isalpha' function*/

/*------------------------------------------------------------------------*/
/*

   Inputs :

    server : This is the name of the machine on which the
      desired service resides.

    service : This is the name of the service to connect to
      
  Outputs :
    sunit:
      If the function return value is negative, the open failed. 
      If return value is positive, then the returned parameter
      sunit is a socket descriptor to the services desired.
*/




int open_socket(char *server, 	/* remote node name */
                char *service, 	/* remote service name */
                int *sunit)
{


  struct sockaddr_in server_sock;
  struct hostent *hp;
  struct servent *sp;
  unsigned long  ipadd;
  int s;

/*
 * Create an socket on which to make the connection.
 *
 * This function call says we want our communications to take
 * place in the internet domain (AF_INET) (the other possible domain
 * is the Unix domain).
 *
 */

  s = socket(AF_INET, SOCK_STREAM, 0);

  if (s < 0) 
  {
    cout << " %% Error opening socket in client" << endl;
    return(FAILURE);
  }

/*
 * Get the IP address of the remote client. It must
 * be in the local machines host table or this call fails. (?)
 *
 * This call returns th 'hp' structure representing the
 * IP address of the remote client.
 *
 */

  if (isalpha(server[0])) 
  {
    hp = gethostbyname(server);	/* probe name server by name */
  } 
  else 
  {
    ipadd = inet_addr(server);	/* convert IP to binary format */
    hp = gethostbyaddr((char*)&ipadd, sizeof(ipadd), AF_INET);	
                               /*probe name server by address */
  }

  if (hp == NULL) 
  {
    cout << " %% Remote host is unknown to name server." << endl;
    return(FAILURE); 
  } 
  else 
  {
    cout << " %% Remote host : " <<  hp->h_name << endl;
  }

/* 
 * If specified as a name the service/port must be defined in the local host 
 * table
 */

  if (isalpha(service[0])) 
  {
    sp = getservbyname(service, "tcp");	/* probe service by name */
    if (sp == NULL) 
    {
      cout << " %% Service not in local host table." << endl;
      return(-1);
    } 
    else 
    {
      server_sock.sin_port = sp->s_port;
    }

  } 
  else 
  {
    server_sock.sin_port = htons(atoi(service)); /* convert ASCII to int. */
  }

/* 
 * create a 'sockaddr_in' internet address structure to use with connect 
 */

  server_sock.sin_family = hp->h_addrtype;
  strncpy((char*)&server_sock.sin_addr, hp->h_addr, hp->h_length);

/* Print IP address in xx.xx.xx.xx format */

  cout << " %% IP address        : " << inet_ntoa(server_sock.sin_addr) << endl;
  cout << " %% Service port # is : " << ntohs(server_sock.sin_port) << endl;

/*
 *  Connect to the socket address.
 */

  if (connect( s, (struct sockaddr *) &server_sock, sizeof(server_sock)) < 0) 
  {
    cout << " %% Attempt to connect to remote host failed." << endl;
    return(FAILURE);
  }

  *sunit = s;		/* return socket channel # as a calling paramter */
  return(SUCCESS);      /* return SUCCESS value */

}

/*-----------------------------------------------------------------------*/

int get_msg (int *socket_channel, char *retstr)
{

/*
 *	Will return count of bytes in returned string (including '\0')
 *	Strings are delimited by '\0'
 */

char	ch[1];
int	status;
int	nbytes;


  nbytes = 0;

/* Read socket buffer a byte at a time */

  while ((status=recv(*socket_channel, (char * ) &ch, 1,NULL)) > 0)
  {
    retstr[nbytes++] = ch[0];	/* build the return string */
    if (ch[0] == 0) 		/* line-feed line terminator ? */
    {
       return (nbytes);	/* return a completed message */
    }
  }
  return (status);		/* error/close-socket return */
}
