/***********************************************************

File Name :
	network_mag.h

Programmer:
	Phil Maechling

Description:
	This is the description of the network mags.
	The current design, pushes as much functionalit as possible
        into the network magnitude routines.

Creation Date:
	11 September 1995

Modification History:


Usage Notes:


**********************************************************/
#ifndef network_mag_H
#define network_mag_H

#include "basics.h"

#define STATION_NAME_SIZE 5
#define MAX_STATIONS_IN_NETWORK 30

struct station_input_data_type
{
  char  station_name[STATION_NAME_SIZE];
  float latitude;
  float longitude;
  float v2c;
  float amlcor;
  float vbbgain;
  float lggain;
};


struct station_output_data_type
{
  float distance_to_event;
  int   seconds_to_s_arrival;

  int   vbb_rate;

  int   z_vbb_samples_used;
  float vbb_mlz;

  int   n_vbb_samples_used;
  float vbb_mln;

  int   e_vbb_samples_used;
  float vbb_mle;

  float vbb_ml;
  float vbb_me;

  //
  //  Lg results
  //

  int   lg_rate;

  int   z_lg_samples_used;
  float lg_mlz;

  int   n_lg_samples_used;
  float lg_mln;

  int   e_lg_samples_used;
  float lg_mle;

  float lg_ml;
  float lg_me;
};

struct calculation_status_type
{
  int vbb_ran;
  int vbb_fatal_error;
  int vbb_component_error;
  int vbb_clipped;
  int vbb_preliminary;
  int vbb_z_err;
  int vbb_n_err;
  int vbb_e_err;

  int lg_ran;
  int lg_fatal_error;
  int lg_component_error;
  int lg_clipped;
  int lg_preliminary;
  int lg_z_err;
  int lg_n_err;
  int lg_e_err;
};


struct station_data_type
{
  struct station_input_data_type  input_data;
  struct station_output_data_type output_data;
  struct calculation_status_type  status;
};


struct station_list_type
{
  int number_of_stations;
  struct station_data_type station_data[MAX_STATIONS_IN_NETWORK];
};

int network_magnitude(
		struct solution_type&     sol,
                struct station_list_type& stalist);


void initialize_results_list(struct station_list_type& station_list);


#endif
