
      subroutine btwfsb(x,y,nx,dt,f1,f2,n,lhorb)
c     butterworth type filter, if lhorb="l","h",or"b", it performs
c     low-pas, high-pass, and band-pass filter, respectively
c     if lhorb="l", then f2 is the cut-off freq., and f1 is dummy
c     if lhorb="h", then f1 is the cut-off freq., and f2 is dummy
c     if lhorb="b", then f1 is low-, and f2 is high-frequency cut off.
c     n is the order, usually 3 or 4
c     x(i) is input and y(i) is output, nx is #of points and dt is dt.
c     the filter response is in w(i) in common, df is freq. increment
c     July, 1990, hiroo kanamori
      character*1 lhorb
      parameter (ndim=240000)
      real*8  a1, a2
      complex c(ndim)
      common/w/w(ndim/2), df
      dimension x(*),y(*)
      nfp=4*n
      call binfd(nx,lx1,np)
      lx1=lx1*2
         if(lx1.gt.ndim)  then
         write(*,*)  ' data too large, increase ndim in btwfsb.f '
         stop
         endif
      np=np+1
      nxp=nx+1
      lhalf=lx1/2
      lcent=lhalf+1
      do i=nxp,lx1
      x(i)=x(nx)
      enddo
      do  i=1, lx1
      c(i)=cmplx(x(i),0.0)
      enddo
      call  cool(np,c,-1.)
      df=1.0/(float(lx1)*dt)
       do  i=1, lcent
       f=float(i-1)*df
       if (lhorb.eq.'l') then
       a2=1./(1.+(f/f2)**nfp)
       w(i)=real(a2)
       else if(lhorb.eq.'h') then
       a1=(f/f1)**nfp/((f/f1)**nfp+1.)
       w(i)=real(a1)
       else if(lhorb.eq.'b') then
       a2=1./(1.+(f/f2)**nfp)
       a1=(f/f1)**nfp/((f/f1)**nfp+1.)
       w(i)=real(a1*a2)
       else 
       write(*,*) 'lhorb should be either l, h, or b'
       stop
       endif
       c(i)=c(i)*cmplx(w(i),0.0)
       enddo
      call conj(c,lcent)
      call cool(np,c,1.)
      do   i=1, nx
      y(i)=real(c(i))/float(lx1)
      enddo
      return
      end

c
c
c
c


      FUNCTION NDAYS(IY1,ID1,IY2,ID2)
C  FINDS THE NUMBER OF DAYS BETWEEN TWO DATES, GIVEN AS YEAR AND DAY; THE
C  SECOND DATE (GIVEN BY IY2 AND ID2) IS TAKEN TO BE LATER. THE NUMBER OF
C  DAYS IS 0 IF THE DATES ARE THE SAME, 1 IF DATE 2 IS ONE DAY LATER, -1
C  IF IT IS ONE DAY EARLIER, AND SO ON.
C   **FOR 16-BIT INTEGERS, THE MAXIMUM SPAN IS 89 YR 257 DAYS.
C
C  $$$$CALLS ONLY SYSTEM ROUTINES
C
C     AUTHOR - DUNCAN CARR AGNEW
C
      LEAP(JJ) = 1 - (MOD(JJ,4)+3)/4
      NDAYS = ID2 - ID1
      IF(IY1.EQ.IY2) RETURN
C  IN SEPARATE YEARS - COUNT UP INTERVENING DAYS
      IF(IY1.GT.IY2) GO TO 5
      NDAYS = 365 + LEAP(IY1) - ID1
      NDAYS = NDAYS + ID2
C  IF YEARS ADJACENT WE ARE DONE
      IF(IY2.EQ.IY1+1) RETURN
      I1 = IY1+1
      I2 = IY2-1
      DO 3 I=I1,I2
      NDAYS = NDAYS + 365 + LEAP(I)
C  CLAVIAN (GREGORIAN) INTERCALATION
 3    IF(MOD(I,100).EQ.0.AND.MOD(I,400).NE.0) NDAYS = NDAYS - 1
      RETURN
C  THIS PART IS USED WHEN THE SECOND YEAR IS EARLIER THAN THE FIRST
 5    NDAYS = 365 + LEAP(IY2) - ID2
      NDAYS = NDAYS + ID1
      IF(IY1.EQ.IY2+1) GO TO 9
      I2 = IY2+1
      I1 = IY1-1
      DO 7 I=I2,I1
      NDAYS = NDAYS + 365 + LEAP(I)
 7    IF(MOD(I,100).EQ.0.AND.MOD(I,400).NE.0) NDAYS = NDAYS - 1
 9    NDAYS = -NDAYS
      RETURN
      END

c
c
c
c
      SUBROUTINE MAXMIN(X,N,AMAX,AMIN)
      DIMENSION X(*)
      AMAX=X(1)
      AMIN=AMAX
      KMAX=1
      KMIN=1
      DO 1100 K=1,N
      AK=X(K)
      IF(AK-AMAX) 120,120,115
115   AMAX=AK
      KMAX=K
      GO TO 1100
120   IF(AK-AMIN) 125, 1100,1100
125      AMIN=AK
      KMIN=K
1100  CONTINUE
      RETURN
      END

c
c
c
c
      SUBROUTINE TAPER (A, N, START, END, B)
      DIMENSION A(*), B(*)
      AN = N
      M1 = AN*START+0.5
      M2 = M1 + 1
      IF(M1) 10, 10, 11
   11 ANG = 3.1415926 / FLOAT(M1)
      DO 12 I=1, M1
      XI = I
      CS = (1.0-COS(XI*ANG))/2.0
   12 B(I) = A(I)*CS
   10 M3 = AN*END+0.5
      M5 = N-M3
      M4 = M5 + 1
      IF(M3) 13, 13, 14
   14 ANG = 3.1415926 / FLOAT (M3)
      DO 15 I=M4,N
      XI = I-N-1
      CS = (1.0-COS(XI*ANG))/2.0
   15 B(I) = A(I)*CS
   13 DO 16 I=M2, M5
   16 B(I) = A(I)
      RETURN
      END
c
c
c
c
      SUBROUTINE DTRD (X, N, Y, NDEG)
      DIMENSION X(*), Y(*)
      AN = N
      S1 = 0.0
      S2 = 0.0
      IF(NDEG) 11, 11, 20
   11 DO 12 I=1,N
   12 S1 = S1+X(I)
      AVEX = S1/AN
      DO 15 I=1,N
   15 Y(I) = X(I) - AVEX
      RETURN
   20 DO 22 I=1,N
      S1 = S1+X(I)
   22 S2 = S2 + S1
      AVEI = 0.5 * (AN+1.0)
      AVEX = S1/AN
      SLOPE = -12.0*(S2-AVEI*S1)/(AN*(AN**2-1.0))
      DO 28 I=1,N
      AI = I
   28 Y(I) = X(I)-AVEX-SLOPE*(AI-AVEI)
      RETURN
      END
c
c
c
c
      SUBROUTINE CALDAT(JULIAN,MM,ID,IYYY)
      PARAMETER (IGREG=2299161)
      IF(JULIAN.GE.IGREG)THEN
        JALPHA=INT(((JULIAN-1867216)-0.25)/36524.25)
        JA=JULIAN+1+JALPHA-INT(0.25*JALPHA)
      ELSE
        JA=JULIAN
      ENDIF
      JB=JA+1524
      JC=INT(6680.+((JB-2439870)-122.1)/365.25)
      JD=365*JC+INT(0.25*JC)
      JE=INT((JB-JD)/30.6001)
      ID=JB-JD-INT(30.6001*JE)
      MM=JE-1
      IF(MM.GT.12)MM=MM-12
      IYYY=JC-4715
      IF(MM.GT.2)IYYY=IYYY-1
      IF(IYYY.LE.0)IYYY=IYYY-1
      RETURN
      END
c
c
c
c
       function aloga0(dist)
       parameter (c=0.49710, an=1.2178, ak=0.00530, dref=8.)
       r=sqrt(dist**2+dref**2)
       aloga0=c*r**(-an)*exp(-ak*r)
       aloga0=-alog10(aloga0)
       return
       end
c
c
c
c
       function   tergain(stnm,chanl,iy,im,id)
c      compute the gain factor for TERRAscope stations           
c      identify station and channel by, for example, pas  and vbbz
c      prepare a table tersta.dat that list the constants.
c      iy, im, id indicate the date, if iy=0 (im, id dummy), then
c      a generic response is used.
       character stnm*10, chanl*5, stnml*10, chanll*5
       parameter (pi=3.14159265,efh=0.26,rb=1.e-10)
       iday=juldat(iy,im,id)
       open(27,file='/home/rtem/engymag/tersta.dat')
310    continue
       read(27,'(a10,a5,4e10.2,i4,i2,i2,1x,i4,i2,i2)',
     2 end=320)  stnml, chanll,f0,h,s,fh,iy1,im1,id1,iy2,im2,id2
       if (iy.eq.0)  then
       if(stnml(1:5).eq.stnm.and.chanll.eq.chanl)  then
       go to 300
       endif
       go to 310
       endif
       iday1=juldat(iy1,im1,id1)
       iday2=juldat(iy2,im2,id2)
       if(stnml(1:5).eq.stnm(1:5) .and. chanll(1:4).eq.chanl(1:4) .and.
     2 ndays(iy1,iday1,iy,iday) .ge. 0 .and. 
     2 ndays(iy,iday,iy2,iday2) .ge. 0) then
       go  to 300
       endif
       go to 310
320    write(*,*) 'The following station is not in tersta.dat'
       write(*,'(a10,a5,i4,2i2)') stnm,chanl,iy,im,id
       stop
300    continue
       tergain=s
       close(27)
       return
       end
c
c
c
c
      function  juldat(iy,m,id)
c     compute julian date,  6/26/1991  h. kanamori
      dimension  idm(12)
      data (idm(i),i=1,12)/31,28,31,30,31,30,31,31,30,31,30,31/
      il=1-mod(iy,4)
      if(mod(iy,100).eq.0.and.mod(iy,400).ne.0)  il=0
      juldat=0
      do 50 i=1, m-1
      juldat=juldat+idm(i)
      if(i.eq.2.and.il.eq.1) juldat=juldat+1
50    continue
      juldat=juldat+id
      return
      end
