
      subroutine btwfsb(x,y,nx,dt,f1,f2,n,lhorb)
c     butterworth type filter, if lhorb="l","h",or"b", it performs
c     low-pas, high-pass, and band-pass filter, respectively
c     if lhorb="l", then f2 is the cut-off freq., and f1 is dummy
c     if lhorb="h", then f1 is the cut-off freq., and f2 is dummy
c     if lhorb="b", then f1 is low-, and f2 is high-frequency cut off.
c     n is the order, usually 3 or 4
c     x(i) is input and y(i) is output, nx is #of points and dt is dt.
c     the filter response is in w(i) in common, df is freq. increment
c     July, 1990, hiroo kanamori
      character*1 lhorb
      parameter (ndim=240000)
      real*8  a1, a2
      complex c(ndim)
      common/w/w(ndim/2), df
      dimension x(*),y(*)
      nfp=4*n
      call binfd(nx,lx1,np)
      lx1=lx1*2
         if(lx1.gt.ndim)  then
         write(*,*)  ' data too large, increase ndim in btwfsb.f '
         stop
         endif
      np=np+1
      nxp=nx+1
      lhalf=lx1/2
      lcent=lhalf+1
      do i=nxp,lx1
      x(i)=x(nx)
      enddo
      do  i=1, lx1
      c(i)=cmplx(x(i),0.0)
      enddo
      call  cool(np,c,-1.)
      df=1.0/(float(lx1)*dt)
       do  i=1, lcent
       f=float(i-1)*df
       if (lhorb.eq.'l') then
       a2=1./(1.+(f/f2)**nfp)
       w(i)=real(a2)
       else if(lhorb.eq.'h') then
       a1=(f/f1)**nfp/((f/f1)**nfp+1.)
       w(i)=real(a1)
       else if(lhorb.eq.'b') then
       a2=1./(1.+(f/f2)**nfp)
       a1=(f/f1)**nfp/((f/f1)**nfp+1.)
       w(i)=real(a1*a2)
       else 
       write(*,*) 'lhorb should be either l, h, or b'
       stop
       endif
       c(i)=c(i)*cmplx(w(i),0.0)
       enddo
      call conj(c,lcent)
      call cool(np,c,1.)
      do   i=1, nx
      y(i)=real(c(i))/float(lx1)
      enddo
      return
      end

c
c
c
c


      FUNCTION NDAYS(IY1,ID1,IY2,ID2)
C  FINDS THE NUMBER OF DAYS BETWEEN TWO DATES, GIVEN AS YEAR AND DAY; THE
C  SECOND DATE (GIVEN BY IY2 AND ID2) IS TAKEN TO BE LATER. THE NUMBER OF
C  DAYS IS 0 IF THE DATES ARE THE SAME, 1 IF DATE 2 IS ONE DAY LATER, -1
C  IF IT IS ONE DAY EARLIER, AND SO ON.
C   **FOR 16-BIT INTEGERS, THE MAXIMUM SPAN IS 89 YR 257 DAYS.
C
C  $$$$CALLS ONLY SYSTEM ROUTINES
C
C     AUTHOR - DUNCAN CARR AGNEW
C
      LEAP(JJ) = 1 - (MOD(JJ,4)+3)/4
      NDAYS = ID2 - ID1
      IF(IY1.EQ.IY2) RETURN
C  IN SEPARATE YEARS - COUNT UP INTERVENING DAYS
      IF(IY1.GT.IY2) GO TO 5
      NDAYS = 365 + LEAP(IY1) - ID1
      NDAYS = NDAYS + ID2
C  IF YEARS ADJACENT WE ARE DONE
      IF(IY2.EQ.IY1+1) RETURN
      I1 = IY1+1
      I2 = IY2-1
      DO 3 I=I1,I2
      NDAYS = NDAYS + 365 + LEAP(I)
C  CLAVIAN (GREGORIAN) INTERCALATION
 3    IF(MOD(I,100).EQ.0.AND.MOD(I,400).NE.0) NDAYS = NDAYS - 1
      RETURN
C  THIS PART IS USED WHEN THE SECOND YEAR IS EARLIER THAN THE FIRST
 5    NDAYS = 365 + LEAP(IY2) - ID2
      NDAYS = NDAYS + ID1
      IF(IY1.EQ.IY2+1) GO TO 9
      I2 = IY2+1
      I1 = IY1-1
      DO 7 I=I2,I1
      NDAYS = NDAYS + 365 + LEAP(I)
 7    IF(MOD(I,100).EQ.0.AND.MOD(I,400).NE.0) NDAYS = NDAYS - 1
 9    NDAYS = -NDAYS
      RETURN
      END

c
c
c
c
      SUBROUTINE MAXMIN(X,N,AMAX,AMIN)
      DIMENSION X(*)
      AMAX=X(1)
      AMIN=AMAX
      KMAX=1
      KMIN=1
      DO 1100 K=1,N
      AK=X(K)
      IF(AK-AMAX) 120,120,115
115   AMAX=AK
      KMAX=K
      GO TO 1100
120   IF(AK-AMIN) 125, 1100,1100
125      AMIN=AK
      KMIN=K
1100  CONTINUE
      RETURN
      END

c
c
c
c
      SUBROUTINE TAPER (A, N, START, END, B)
      DIMENSION A(*), B(*)
      AN = N
      M1 = AN*START+0.5
      M2 = M1 + 1
      IF(M1) 10, 10, 11
   11 ANG = 3.1415926 / FLOAT(M1)
      DO 12 I=1, M1
      XI = I
      CS = (1.0-COS(XI*ANG))/2.0
   12 B(I) = A(I)*CS
   10 M3 = AN*END+0.5
      M5 = N-M3
      M4 = M5 + 1
      IF(M3) 13, 13, 14
   14 ANG = 3.1415926 / FLOAT (M3)
      DO 15 I=M4,N
      XI = I-N-1
      CS = (1.0-COS(XI*ANG))/2.0
   15 B(I) = A(I)*CS
   13 DO 16 I=M2, M5
   16 B(I) = A(I)
      RETURN
      END
c
c
c
c
      SUBROUTINE DTRD (X, N, Y, NDEG)
      DIMENSION X(*), Y(*)
      AN = N
      S1 = 0.0
      S2 = 0.0
      IF(NDEG) 11, 11, 20
   11 DO 12 I=1,N
   12 S1 = S1+X(I)
      AVEX = S1/AN
      DO 15 I=1,N
   15 Y(I) = X(I) - AVEX
      RETURN
   20 DO 22 I=1,N
      S1 = S1+X(I)
   22 S2 = S2 + S1
      AVEI = 0.5 * (AN+1.0)
      AVEX = S1/AN
      SLOPE = -12.0*(S2-AVEI*S1)/(AN*(AN**2-1.0))
      DO 28 I=1,N
      AI = I
   28 Y(I) = X(I)-AVEX-SLOPE*(AI-AVEI)
      RETURN
      END
c
c
c
c
      function  juldat(iy,m,id)
c     compute julian date,  6/26/1991  h. kanamori
      dimension  idm(12)
      data (idm(i),i=1,12)/31,28,31,30,31,30,31,31,30,31,30,31/
      il=1-mod(iy,4)
      if(mod(iy,100).eq.0.and.mod(iy,400).ne.0)  il=0
      juldat=0
      do 50 i=1, m-1
      juldat=juldat+idm(i)
      if(i.eq.2.and.il.eq.1) juldat=juldat+1
50    continue
      juldat=juldat+id
      return
      end
c
c
c
c
      SUBROUTINE CONJ(C,LX1)
C     LX1 = 2**N/2 + 1
      COMPLEX C(*)
      NM1 = LX1 - 1
      DO 30 I=1, NM1
      NT = LX1 + I
      NU = LX1 - I
      C(NT) = CONJG (C(NU))
   30 CONTINUE
      C(LX1) = CMPLX (REAL(C(LX1)),0.0)
      RETURN
      END
c
c
c
c
      SUBROUTINE BINFD(LX,LX1,N)
c      lx should be eq. to less than 2**20 (1048576)
C     2**N.LE.LX.LT.2**(N+1)

      DO 3 I=1,20
      IND = 2**I
      IF(LX-IND) 4, 5, 3
    3 CONTINUE
      N = 100
      write(*,*)  'Warning  lx too large!'
      RETURN
    4 CONTINUE
      N = I-1
      GO TO 6
    5 CONTINUE
      N = I
    6 CONTINUE
      LX1 = 2**N
      RETURN
      END
c
c
c
c
      SUBROUTINE COOL(NN,DATAI,SIGNI)
      DIMENSION DATAI(*)
      N=2**(NN+1)
      J=1
      DO 5 I=1,N,2
      IF(I-J)1,2,2
    1 TEMPR=DATAI(J)
      TEMPI=DATAI(J+1)
      DATAI(J)=DATAI(I)
      DATAI(J+1)=DATAI(I+1)
      DATAI(I)=TEMPR
      DATAI(I+1)=TEMPI
    2 M=N/2
    3 IF(J-M)5,5,4
    4 J=J-M
      M=M/2
      IF(M-2)5,3,3
    5 J=J+M
      MMAX=2
    6 IF(MMAX-N)7,10,10
    7 ISTEP=2*MMAX
      THETA=SIGNI*6.28318531/FLOAT(MMAX)
      SINTH=SIN(THETA/2.)
      WSTPR=-2.0  *SINTH*SINTH
      WSTPI= SIN(THETA)
      WR=1.
      WI=0.
      DO 9 M=1,MMAX,2
      DO 8 I=M,N,ISTEP
      J=I+MMAX
      TEMPR=WR*DATAI(J)-WI*DATAI(J+1)
      TEMPI=WR*DATAI(J+1)+WI*DATAI(J)
      DATAI(J)=DATAI(I)-TEMPR
      DATAI(J+1)=DATAI(I+1)-TEMPI
      DATAI(I)=DATAI(I)+TEMPR
    8 DATAI(I+1)=DATAI(I+1)+TEMPI
      TEMPR=WR
      WR=WR*WSTPR-WI*WSTPI+WR
    9 WI=WI*WSTPR+TEMPR*WSTPI+WI
      MMAX=ISTEP
      GO TO 6
   10 RETURN
      END
c
c
c
c

      SUBROUTINE RESMS(F,PT,E,R,ARG,IND)
C     UNDERDAMPED CASE, E: DAMPING RATIO
C     OVERDAMPED CASE, E=-H, (H=1, CRITICAL DAMPING, H: DAMPING CONSTANT  )
      IF(IND .GT. 0) GO TO 300
      PI = 3.1415926
      TWOPI = 2.0*PI
      FN1 = TWOPI/PT
      IF  ( E .LT. 0.0 )  GO TO 305
      A = ALOG(E)
      B = SQRT(PI**2+A**2)
      AE = FN1*A/B
      GO TO 300
  305 AE = FN1 * (-E)
  300 W = TWOPI*F
      C = (FN1**2-W**2)**2+4.0*(W**2)*(AE)**2
      C = SQRT(C)
      R = W**2/C
      A = 2.0*AE*W
      B = FN1**2-W**2
      ARG = ATAN2(A,B)
      ARG = -ARG
C     ARG = PHASE ADVANCE
C     INPUT = SIN(WT) THEN OUTPUT = SIN(WT+ARG)
      RETURN
      END


