/***********************************************************

File Name :
	get_cda_ts.c

Programmer:
	Phil Maechling

Description:
	This is the cda version of getdata. It will read the
	contiguous data area and extract the requested data.

Limitations or Warnings:


Creation Date:
	9 June 1995

Modification History:


**********************************************************/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>

#include "basics.h"
#include "get_cda_ts.h"
#include "getdata.h"
#include "qtime.h"

//
// This construction is supposed to be done once, on program
// startup, and not every time the get_cda_time_series is called.
//

GetData cda_data;

int get_cda_time_series(INT_TIME  eq_time,
                        char*     sta_name,
			int       sensor_type,
	  		int*      sps,
			int       z_array[],
			INT_TIME* z_time,
			int*      z_samples,
		        int       n_array[],
			INT_TIME* n_time,
			int*      n_samples,
			int       e_array[],
                        INT_TIME* e_time,
			int*      e_samples)

{

/*
* Create the extraction strings
*/

    switch(sensor_type)
    {
      case VBB:
      {
        cda_data.get_segment(sta_name,"BHZ",eq_time,VBB_DURATION,
			     sps,z_time,z_samples,z_array);

        cda_data.get_segment(sta_name,"BHN",eq_time,VBB_DURATION,
			     sps,n_time,n_samples,n_array);

        cda_data.get_segment(sta_name,"BHE",eq_time,VBB_DURATION,
			     sps,e_time,e_samples,e_array);

        break;
      }
      case LG:
      {

        cda_data.get_segment(sta_name,"HLZ",eq_time,LG_DURATION,
			     sps,z_time,z_samples,z_array);

        cda_data.get_segment(sta_name,"HLN",eq_time,LG_DURATION,
			     sps,n_time,n_samples,n_array);

        cda_data.get_segment(sta_name,"HLE",eq_time,LG_DURATION,
			     sps,e_time,e_samples,e_array);
	
      } 
    }

  return(SUCCESS); 
}

