/***********************************************************

File Name :
	final.C

Programmer:
	Phil Maechling

Description:

  This performs processing to determine if an event has been
  finalized by TERRAvision mag.

  This is routine that keeps a list of finalized events.
  When an event is input to item, it is checked against
  the finalized list.

  If the event is on the list, and if the latitude, and
  longitude match the exisiting data, then the event
  is not reprocessed.

Creation Date:

	8 September 1995

Modification History:


Usage Notes:


**********************************************************/
#include <iostream.h>
#include "basics.h"
#include "final.h"
#include "solution.h"
#include "tvmag.h"

static struct solution_type event_array[NUMBER_OF_FINALIZED_EVENTS];

void clear_event_array()
{
  int icnt;

  for(icnt=0;icnt<NUMBER_OF_FINALIZED_EVENTS;icnt++)
  {
    event_array[icnt].event_id = 0;
  }
  return;
}

void make_event_final(struct solution_type& sol)
{
  static int next_event = 0;

  if (next_event==NUMBER_OF_FINALIZED_EVENTS)
  {
    next_event = 0;
  }

  event_array[next_event] = sol;
  next_event++;
  return;

}

int event_was_finalized(struct solution_type& sol)
{
  int icnt;

  for (icnt=0;icnt<NUMBER_OF_FINALIZED_EVENTS;icnt++)
  {
    if ( (event_array[icnt].event_id  == sol.event_id) &&
         (event_array[icnt].latitude  == sol.latitude) &&
         (event_array[icnt].longitude == sol.longitude) )
    {
         return(TRUE); /* return true. event was finalized */
    }
  }

  return(FALSE); /* event not on list so it was not finalized */

}

