/***********************************************************

File Name :
	engymagr.h

Programmer:
	Phil Maechling

Description:
	Header file for the engymag program
        program to integrate square of a time series, and compute
        energy magnitude

        version 1.0, sed 1/31/1993  h. kanamori
        W-A response is also computed
        h. kanamori,  3/1/1991 

Creation Date:
	12 September 1995

Modification History:


Usage Notes:


	At least one component of the input time series is 
 	expected to contain more than 1 sample in it.

       A time series if any of the components have 0 count
	in them, the component error flag rcerror is set.
	If the rcerror flag is set, the average mags are invalid
	The component mag may still be good in this case.
	Number of samples is from nd value, not checking ts.

       Station names are all 5 characters. Input station is expected
	to be three then is padded with blanks to 5 characters.
	
	Program constants were in i_engymag or c_engymag. (eg CQR0)
	Now they are in terramag.inc.
	Recompilation needed if these change.

	Hardcoded file names include
	/home/rtem/engymag/stalist - station locations
	/home/rtem/engymag/stacor.dat - stations corrections

**********************************************************/
/*
c	ista	      = station name
c	iyre,iday etc = year, day, and time of event
c	tsyr,tsday    = year,day,and time of start of time series
c	alate,alonge  = event lat long and depth
c	dist          = distance to event
c	snsrtype      = 0 = VBB 1 = LG
c	dt	      = seconds per sample
c	nd(3)	      = number of samples in each compoenent
c	pt(3,MAX SAMPLES) = array containing 3 components of time series
c			and order IS SIGNFICANT (1 = Z, 2 = N, 3 = E )
c
c	Outputs
c
c	rferror		= fatal error flag (0 = ok, 1 or larger = fatal error)
c	rcerror		= component error (0 = ok, 1 = error on a component)
c	rdist		= distance from station to event
c       rclip           = indicator that component is clipped (0=ok 1=clipped)
c       rupdate         = update needed. more sample (0=ok 1=update needed)
c	rzerr,rnerr,reerr = Component error flags, 
c			    if rcerror set, problems component flag = 1 
c	rmlz,rmln,rmle  = ml for each component
c	ramlav		= ml average for the 23 components
c	renmag		= me for the three components
c
c
c
c
c
*/
#ifndef engymagr_H
#define engymag_H

#ifndef __cplusplus
extern "C"
{
engymagr (
	2 ista,
	2 iyre,ide,ihe,ime,isece,
	2 alate,alonge,depth,
	2 dist,
	2 tsyr,tsday,tshr,tsmin,tssec,
	2 snsrtype,
	2 dt,
	2 nd,
	2 pt,
	2 rferror,
	2 rcerror,
	2 rclip,
	2 rupdate,
	2 rdist,
	2 rzerr,rnerr,reerr,
	2 rmlz,rmln,rmle,
	2 ramlav,renmag);
}
#else
engymagr (
	2 ista,
	2 iyre,ide,ihe,ime,isece,
	2 alate,alonge,depth,
	2 dist,
	2 tsyr,tsday,tshr,tsmin,tssec,
	2 snsrtype,
	2 dt,
	2 nd,
	2 pt,
	2 rferror,
	2 rcerror,
	2 rclip,
	2 rupdate,
	2 rdist,
	2 rzerr,rnerr,reerr,
	2 rmlz,rmln,rmle,
	2 ramlav,renmag);

#endif
#endif

