c
c       engymagr
c       version 1.0, sed 1/31/1993  h. kanamori
c       program to integrate square of a time series, and compute
c       energy magnitude
c       W-A response is also computed
c       h. kanamori,  3/1/1991 
c
c 	subroutine version for use in all engymag software on terra10
c	created 16/May/94 PJM
c
c	Limitations:
c
c	If the fatal error flag, rferror is set, no results are 
c	useful.
c
c	At least one component of the input time series is 
c	expected to contain more than 1 sample in it.
c
c       A time series if any of the components have 0 count
c	in them, the component error flag rcerror is set.
c	If the rcerror flag is set, the average mags are invalid
c	The component mag may still be good in this case.
c	Number of samples is from nd value, not checking ts.
c
c       Station names are all 5 characters. Input station is expected
c	to be three then is padded with blanks to 5 characters.
c	
c	Program constants were in i_engymag or c_engymag. (eg CQR0)
c	Now they are in terramag.inc.
c	Recompilation needed if these change.
c
c
c	Inputs:
c
c	iyre,iday etc = year, day, and time of event
c	tsyr,tsday    = year,day,and time of start of time series
c	alate,alonge  = event lat long and depth
c	dist	      = distance to event
c	snsrtyp       = vbb = 0 lg = 1
c	dt	      = seconds per sample
c	nd(3)	      = number of samples in each compoenent
c	pt(3,MAX SAMPLES) = array containing 3 components of time series
c			and order IS SIGNFICANT (1 = Z, 2 = N, 3 = E )
c
c	Outputs
c
c	rferror		= fatal error flag (0 = ok, 1 or larger = fatal error)
c	rcerror		= component error (0 = ok, 1 = error on a component)
c       rclip           = indicator that component is clipped (0=ok 1=clipped)
c       rupdate         = update needed. more sample (0=ok 1=update needed)
c	rzerr,rnerr,reerr = Component error flags, 
c			    if rcerror set, problems component flag = 1 
c	rmlz,rmln,rmle  = ml for each component
c	ramlav		= ml average for the 23 components
c	renmag		= me for the three components
c
c
c
c
c

	subroutine engymagr (
	2 zv2c,zamlcor,zvbgain,zlggain,
	2 iyre,ide,ihe,ime,isece,
	2 dist,depth,
	2 tsyr,tsday,tshr,tsmin,tssec,
	2 snsrtyp,
	2 dt,
	2 nd,
	2 pt,
	2 rferror,
	2 rcerror,
	2 rclip,
	2 rupdate,
	2 rzerr,rnerr,reerr,
	2 rmlz,rmln,rmle,
	2 ramlav,renmag)

c
c Start of variable declarations
c
	include '/home/phil/da/pjlib/terramag.inc'
c
c
c
	real zv2c,zamlcor,zvbgain,zlggain
	integer	iyre,ide,ihe,ime,isece,imse
	integer tsyr(3),tsday(3),tshr(3),tsmin(3)
	integer tssec(3)
	real dist,depth
	integer snsrtyp
	real dt
	integer nd(3)
	integer rferror,rcerror,rzerr,rnerr,reerr
	integer	rclip,rupdate
	real    rmlz,rmln,rmle
	real	ramlav,renmag


        integer       avd

	parameter  (ndim=MAX_SAMPLES_IN_SERIES,tp=0.8, e=-0.8,amag=2800.,avd=1)

	real	   pt(3,ndim)
	real       sx(ndim), xx(2*ndim),xf(ndim)

	common /ts/ x(ndim), t(ndim), intg
c
c Set error variable to false. Set msec values to zero. set cliped to no
c

	rferror  = 0
	rcerror  = 0
	rclip   = 0	
	rupdate = 0
	imse    = 0
	rzerr	= 0
	rnerr	= 0
	reerr	= 0
	rmlz    = 0.0
	rmln    = 0.0
	rmle    = 0.0
	ramlav  = 0.0
	renmag  = 0.0

c
c Assign parameters values to input data
c
c density and velocity
c
	rho = RHO1
	velocity = VELOCITY1
c
c energy attenuation parameters,  and reference depth
c
	cqr0  = CQR01
        anqr0 = ANQR01
        akqr0 = AKQR01
        rref  = RREF1
c
c	2 sets of coefficients for logE vs M'
c
	cen1a = CEN1A1
	cen1b = CEN1B1
	cen2a = CEN2A1
	cen2b = CEN2B1

c
c Assign stacor values.
c
	v2c  = zv2c
	amlcor = zamlcor

c
c Stations corrections found
c
c
	depthr=depth
	diste = dist
c
c  Calculate the range to the event. Dist plus depth
c
	range=sqrt(dist**2+depthr**2)

	amp0=qr1(rref,cqr0,anqr0,akqr0)
	amp=qr1(range,cqr0,anqr0,akqr0)
	ensum=0.0
	amlav=0.0
	ntrace=0
	amult=rho*velocity*4.*3.141592*rref**2*amp0**2/(4.*amp**2)
	amult=amult*1.e15

c
c Processing of ecach component start here
c

        do  300 icnt=1,3

c
c Change current century value at turn of century.
c
c
        iyrs  = tsyr(icnt)
        ids   = tsday(icnt)
        ihs   = tshr(icnt)
        ims   = tsmin(icnt)
        isecs = tssec(icnt)
        imss  = 0
c
c
c Specify samples in array. If too much data, set rferror
c
c
	n = nd(icnt)
        if(n.gt.ndim) then
	  write(STDOUT,*) 'too many samples, increase ndim'
	  rferror = 3
          return
	endif
c
c Check for component error. Set error flag
c
c Set component error on 10 seconds of vbb or 2 seconds of 100 sps lg
c
c
	if (n.lt.200) then
	  rcerror = 1
        
	  if (icnt .eq. 1) then
	    rzerr = 1
	  else if (icnt .eq. 2) then
	    rnerr = 1
	  else 
	    reerr = 1
          end if
c
c Continue loop on next component
c	
 	  goto 300

	endif
c
c Component will be used. Increase ntrace.
c Ntrace count number of "good" components
c 
        ntrace=ntrace+1
c
c
c new gain data retrieval
c

        amultv=1./zvbgain
        amults=1./zlggain
c
c Calculate p and s wave travel times
c        

	ndayd=ndays(iyre,ide,iyrs,ids)
        idif=ndayd*24*3600+(ihs-ihe)*3600+(ims-ime)*60+(isecs-isece) 
        sdif=float(idif)+(imss-imse)*0.001
        ptimes=ptime(diste,depthr,6.3)
        sptimes=ptimes*0.731

c
c N holds number of samples in current component. Transfer these samples
c   into x array for processing.
c
	do 101 i=1,n
	  x(i) = pt(icnt,i)
101	continue	
c
c       check for clipping 
c
        call maxmin(x,n,xmax,xmin)
        if (xmax-xmin.gt.1.e7)  then
	  write(*,*) 'Setting clip flag.xmax.xmin.xmax-xmin'
	  write(*,*) xmax,xmin,xmax-xmin
          rclip = 1
        endif
c
c remove bias and taper time series
c
	call  dtrd(x,n,sx,1)
        call taper (sx,n,0.05, 0.05,x)
c
c Set the t(i) values
c
	do 53  i=1, n
	t(i)=float(i-1)*dt
53      continue
c
c Check if we have velocity or acceleration data
c
c
c Strong motion (accleration) data
c
        if(snsrtyp.eq.LG) then
       	sx(1)=0.0

        do i=2, n
        sx(i)=sx(i-1)+x(i)*dt
        end do

        do 59  i=1,n
        x(i)=sx(i)*amults
59      continue
c
c VBB (velocity) data
c
        else if(snsrtyp.eq.VBB) then
	do 62 i=1, n
	x(i)=x(i)*amultv
62      continue
        else
c
c Return rferror message
c
	write(STDOUT,*) 'data type must be either 0 (v),  or 1 (s)'
        rferror = 4
	return	
	endif
c
c   Now there is velocity data in x(i), i=1, n
c
c   So  compute preliminary ML to determine whether anti-microseism
c   filter is required or not
c
        do i=1, n
        xx(i)=x(i)
        end do
        call wares(xx,n,dt,tp,e,amag,sx,avd)
        call maxmin(sx,n,amax,amin)
        amax1=abs(amax)
        amax2=abs(amin)
        if (amax1.lt.amax2) amax1=amax2
	amlst=alog10(amax1*10.)+aloga0(dist)
        amlpre=amlst+amlcor

        if (amlpre.lt.5.)  then
c
c       if preliminary ML>=5, no filter is applied
c       if preliminary ML<5, appropriate fc1 and fc2 are computed
c       and high-pass filter is applied
c
        fc1=1./antmcrf(amlpre)
        fc2=1./antmcrf(amlpre)
	nbt=2
        call btwfsb(x,xf,n,dt,fc1,fc2,nbt,'h')
	do 69 i=1,n
	x(i)=xf(i)
69      continue
	endif
c
c Filtering decision and calculation done. Move final time sereis
c  to xx()
c
        do 64 i=1, n
        xx(i)=x(i)
64      continue
        call maxmin(x,n,amax,amin)
c
c       compute Wood-Anderson response
c
        call wares(xx,n,dt,tp,e,amag,sx,avd)
        call maxmin(sx,n,amax,amin)
        amax1=abs(amax)
        amax2=abs(amin)
        if (amax1.lt.amax2) amax1=amax2
	amlst=alog10(amax1*10.)+aloga0(dist)

c
c Assign the componenet ml
c
	if (icnt.eq.1) then
	  rmlz = amlst+amlcor	
	else if (icnt.eq.2) then
	  rmln = amlst+amlcor
        else
          rmle = amlst+amlcor
        endif
c
c
c removed test for trace 1. amlr set for each trace
c
c       if(ntrace.eq.1)  amlr=amlst+amlcor
c
        amlr=amlst+amlcor
	amlav=amlav+amlst
c
c
c       compute energy
c       compute v**2(t)"
c
        recdur=ptimes+sptimes+durtn(amlr)-sdif
        ninteg=recdur/dt

c
c Check if time series is sufficient for energy mag 
c
        if(ninteg.gt.n)  then
          ninteg=n
c
c Set return flag saying update is needed
c
	  rupdate = 1

        endif
c
c
c
	sx(1)=0.0
        do  i=2, ninteg
        sx(i)=sx(i-1)+x(i)**2*dt
        end do

	call maxmin(sx,ninteg,amax,amin)
	ensum=ensum+amax

300     continue
c
c The following lines are done after all three components have been processed
c Average over only valid components
c
        amlav=amlav/float(ntrace)
c
c  Assign a return value for a three component Ml (average)
c
	ramlav = amlav+amlcor
c
c Now complete the energy magnitude calculations
c
	energy=amult*ensum
	energycor=amult*ensum*v2c
	enmag1=alog10(energy)-cen1b
	enmag1=enmag1/cen1a
        enmag2=alog10(energy)-cen2b
	enmag2=enmag2/cen2a
	enmag1cor=alog10(energycor)-cen1b
	enmag1cor=enmag1cor/cen1a
        enmag2cor=alog10(energycor)-cen2b
	enmag2cor=enmag2cor/cen2a
c
c Assign the return value to energymag variable
c
 	if(enmag2cor.lt.1.0) then
	  renmag =1.0
        else
	  renmag =enmag2cor
	endif
c
c Return to calling routine
c
	return
	end
