#include "epackets.h"
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <memory.h>
const char      socket_file[] = "/home/rtem/ports/socket_list";

int             sd;

DATA_HDR* get_packet(unsigned char * indata)
{
  int             nr, socket_err, j, blksize;
  DATA_HDR	*hdr;
  BS		*bs = NULL;
  BLOCKETTE_HDR	*bh = NULL;
  int goodpacket;

  goodpacket = 0;

  while(!goodpacket)
  {
	  nr = xread(sd, (char *)indata, MIN_BLKSIZE);
          if (nr <= 0)
          {
            fprintf(stderr,"Socket read returned EOF : %d. Exiting\n",nr);
            exit(-1);
          }
	  else if (nr < MIN_BLKSIZE) 
          {
	    fprintf (stderr, "Error reading from socket: expected %d got %d\n", MIN_BLKSIZE, nr);
	    continue;
	   }
	   if ((hdr = decode_hdr_sdr ((SDR_HDR *)indata, &blksize)) == NULL) 
           {
	     fprintf (stderr, "Error decoding SEED data hdr\n");
	     continue;
	   }
	   if (blksize > MIN_BLKSIZE) 
           {
	      nr = xread (sd, (char *)indata + MIN_BLKSIZE, blksize-MIN_BLKSIZE);
	      if (nr < blksize-MIN_BLKSIZE) 
              {
		fprintf (stderr, "Error reading SEED data\n");
		continue;
	       }
	    }
        
            goodpacket = 1;

	    /* Fill in the number of data frames.   */
	    if ((bs = find_blockette(hdr,1001)) &&
		(bh = (BLOCKETTE_HDR *)(bs->pb))) 
            {
		hdr->num_data_frames = ((BLOCKETTE_1001 *)bh)->frame_count;
		/* Explicitly set num_data_frames for SHEAR stations.	*/
		if (hdr->num_data_frames == 0 && hdr->sample_rate != 0)
		    hdr->num_data_frames = (blksize - hdr->first_data) / sizeof(FRAME);
	     }
	     else 
             {
                hdr->num_data_frames =
		(hdr->sample_rate == 0) ? 0 :
		(blksize - hdr->first_data) / sizeof(FRAME);
             }
  } /* End while !goodpacket */
  return (hdr);
}

int
init_input(char *station)
{
	struct hostent *hp;
	struct sockaddr_in sin;
	char            errstr[255], hostname[63], tstation[15],tempstr[255];
	fp              fp_sckts;
	int             socketno, found = LARSON_FALSE;
	unsigned char	*data;
	DATA_HDR	*hdr;
	int		status;

	/* Get host and socket number from file */
	efopen(socket_file, "r", fp_sckts);
	while (!feof(fp_sckts)) {
		fgets(tempstr, 255, fp_sckts);
		sscanf(tempstr, "%s%s%i", tstation, hostname, &socketno);
		if (strcmp(station, tstation) == 0) {
			found = LARSON_TRUE;
			break;
		}
	}
	fclose(fp_sckts);
	if (found == LARSON_FALSE)
		rdsmplerr(243, "Station not found in file: socket_list\n");

	/* Initialize socket */
	errno = 0;
	if ((hp = gethostbyname(hostname)) == 0) {
		sprintf(errstr,"init_input:\ngethostbyname: %s\n",sys_errlist[errno]);
		rdsmplerr(245,errstr);
		return -1;
	}
	memset((void *)&sin, 0, sizeof(struct sockaddr_in));
	memcpy((void *)&sin.sin_addr, (void *)hp->h_addr, hp->h_length);
	sin.sin_family = AF_INET;
	sin.sin_port = socketno;
	if ((sd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
		sprintf(errstr,"init_input:\nsocket: %s\n",sys_errlist[errno]);
		rdsmplerr(245,errstr);
		return -1;
	}
	if (connect(sd, (struct sockaddr *) &sin, sizeof(sin)) <0) {
		sprintf(errstr,"init_input:\nconnect: %s\n",sys_errlist[errno]);
		rdsmplerr(244,errstr);
		return -1;
	}
	/* Get a packet (it is a leftover) */
	data = (unsigned char *)malloc(MAX_BLKSIZE * sizeof(char));
	hdr = get_packet((unsigned char *)&data);

	/* Make sure this is the right socket */
	if (hdr == NULL) {
		fprintf (stderr, "Unable to read from socket\n");
		exit(1);
	}
	if (strcasecmp(hdr->station_id,station) != 0) {
		sprintf(errstr,"init_input:\nstation expected: -%s-\nstation read: -%s-\n",station,hdr->station_id);
		rdsmplerr(250, errstr);
		status = -1;
	} else
		status = 0;

	free_data_hdr (hdr);
	return (status);
}

