#include <time.h>
#include <string.h>
#include <stdio.h>
#include "epackets.h"
#include <time.h>
#include <memory.h>
#include <sunmath.h>

char            stationname[40];
/* #include "terramag.h" */


char *detect_codes[3]={"Probably Spurious","","Probably a real event"};

void
rdsmplerr(int errcode, char *errmsg)
{
	char            syscall[255];
	static char     username[63];
	static int      mesgs = 0;
	time_t          oldtime, newtime;

	if (mesgs == 0)
		if (strcpy(username, getenv("USER")) == NULL)
			fprintf(stdout,"No known user\n");
	if (mesgs == 0)
		time(&oldtime);
	else if (mesgs > 20) {
		time(&newtime);
		if (newtime - oldtime < 600) {
/*			sprintf(syscall, "mail %s <<EOF \n%s\nToo many messages sent in allotted time.\nCrashing to prevent overload.\nEOF", username, stationname);
			errcode = mesgs;*/
		}
		mesgs = -1;
		oldtime = newtime;
	}
	mesgs++;
	if (errcode > 4) {
/*		sprintf(syscall, "mail  -s \"qqt error %s\" %s <<EOF \n%s\n Errorcode: %i\nEOF\n",stationname, username, errmsg, errcode);
		system(syscall);
		if (errcode > 8)
			exit(errcode); */
	} else {
		fp              fp_errs;
		efopen("e_qqtrt", "a", fp_errs);
		fprintf(fp_errs, "%s\n", errmsg);
		fclose(fp_errs);
	}
}

void rdsmpl_(int *num, 
             float *fvert, float *fnorth, float *feast, 
             time_t *time, int *msec, 
             int *retcode)

{
	long  *vert, *north, *east;
	int             i;
	if (*num > 0) {
		vert  = (long *) malloc(sizeof(long) * *num);
		north = (long *) malloc(sizeof(long) * *num);
		east  = (long *) malloc(sizeof(long) * *num);
	} 
	*retcode = read_next_sample(*num, vert, north, east, time, msec);
	for (i = 0; i < *num; i++) {
		fvert[i] = vert[i];
		fnorth[i] = north[i];
		feast[i] = east[i];
	}
	if (*num > 0) {
		free(vert);
		free(north);
		free(east);
	}
}

int
initinp_(char *station)
{
	int             i = -1;

	strncpy(stationname, station, 10);
	while (stationname[++i] != ' ');
	stationname[i] = 0;
	return (init_input(stationname));
}

void tmstr_(long *secs, long *msec, float *dsecs, char *str)
{
	ldiv_t          ldivtemp;
	struct tm       etime;
	long            temp, nsecs, nmsec;
	float           ndsecs;

	nsecs = *secs;
	nmsec = *msec;
	ndsecs = *dsecs;
	temp = irint(ndsecs);
	nsecs += temp;
	nmsec += irint((float) (ndsecs - temp) * 1000.0);
	ldivtemp = ldiv(nmsec, 1000);
	nmsec = ldivtemp.rem;
	nsecs += ldivtemp.quot;
	if (nmsec < 0) {
		nmsec += 1000;
		nsecs--;
	}
	memcpy(&etime, gmtime(&nsecs), sizeof(struct tm));
	strftime(str, 70, "%x %X", &etime);
	sprintf(str, "%s.%ld GMT", str, nmsec);
	str[strlen(str)]=' ';
}

void tmstr_qqt5_(long *secs, long *msec, float *dsecs, char *str)
{
	ldiv_t          ldivtemp;
	struct tm       etime;
	long            temp, nsecs, nmsec;
	float           ndsecs;

	nsecs = *secs;
	nmsec = *msec;
	ndsecs = *dsecs;
	temp = irint(ndsecs);
	nsecs += temp;
	nmsec += irint((float) (ndsecs - temp) * 1000.0);
	ldivtemp = ldiv(nmsec, 1000);
	nmsec = ldivtemp.rem;
	nsecs += ldivtemp.quot;
	if (nmsec < 0) {
		nmsec += 1000;
		nsecs--;
	}

        nsecs = nsecs - 28800;

	memcpy(&etime, gmtime(&nsecs), sizeof(struct tm));

	strftime(str, 70, "%x %X", &etime);
	sprintf(str, "%s.%3.3ld GMT", str, nmsec);
	str[strlen(str)]=' ';
}

