/***********************************************************

File Name :
	qqccfile.c

Programmer:
	Phil Maechling

Description:
	This file can be used to input data from a hk file into
	plotmag. It is slightly different from the qqcfile.c file
	as this can be called from c routines, while the other
	expects a fortran program to call it.

Creation Date:


Modification History:


Usage Notes:


**********************************************************/



#include <time.h>
#include <string.h>
#include <stdio.h>
#include "larson.h"

/* #include "terramag.h"*/

#define ERRCODEMAX 15
time_t     rtime;
char            stationname[40];
Vector          datavec[3];
int             samples,curr_point,deltat, millisec;
void
rdsmplerr(int errcode, char *errmsg)
{
	char            syscall[255];

	fprintf(stderr, "station=%s\n%s\n Errorcode: %i\n", stationname, errmsg, errcode);
	system(syscall);
	if (errcode > ERRCODEMAX)
		exit(errcode);
}

void
rdsmpl_(int *num, float *fvert, float *fnorth, float *feast, int *time, int *msec, int *retcode)
{
	int             i;
	int             oset;
	ldiv_t          ldivtemp;
	oset = *num * sizeof(float) * 3;
	if (*num <= 0) {
		if ((curr_point + *num) < 0) {
			rdsmplerr(63, "Invalid backwards step");
			*retcode = 1;
		} else {
			curr_point += *num;
			millisec += *num * deltat;
			ldivtemp = ldiv(millisec, 1000);
			rtime += ldivtemp.quot;
			*time = rtime;
			*msec = millisec = ldivtemp.rem;
			*retcode = *num;
		}
	} else {
		if (curr_point + *num > samples)
			exit(1);
		for (i = 0; i < *num; i++) {
			fvert[i] = datavec[0][curr_point];
			fnorth[i] = datavec[1][curr_point];
			feast[i] = datavec[2][curr_point];
			curr_point++;
		}
		millisec += *num * deltat;
		if(millisec>999) {
			ldivtemp = ldiv(millisec, 1000);
			rtime += ldivtemp.quot;
			millisec = ldivtemp.rem;
		}
		*time = rtime;
		*msec =millisec;
		*retcode = *num;
	}
}

void
init_input(char *filename)
{
	fp              fp_hk[3];
	Filename		infile;
	char            tempstr[255], newstr[13];
	float           delt;
	int             h, i=-1, j;
	long			temp;
	struct tm       tmv;

	strcpy(stationname, filename);
	sprintf(infile, "%s_Z", filename);
	efopen(infile, "r", fp_hk[0]);
	sprintf(infile, "%s_N", filename);
	efopen(infile, "r", fp_hk[1]);
	sprintf(infile, "%s_E", filename);
	efopen(infile, "r", fp_hk[2]);
	filename[i] = ' ';
	for (i = 0; i < 3; i++)
		fgets(tempstr, 255, fp_hk[i]);
	for (i = 0; i < 3; i++)
		fgets(tempstr, 255, fp_hk[i]);
	sscanf(tempstr,"%i%i%i%i%i%d",&tmv.tm_year,&tmv.tm_yday,&tmv.tm_hour,&tmv.tm_min,&tmv.tm_sec,&millisec);
	temp=julday(1,1,tmv.tm_year)+tmv.tm_yday-1;
	caldat(temp,&tmv.tm_mon,&tmv.tm_mday,&temp);
	tmv.tm_isdst = 0;
	tmv.tm_wday = 0;
	tmv.tm_year -= 1900;
	tmv.tm_mon -= 1;
        /* tmv.tm_hour -=8; */ /* Solaris mktime converts to local time */
	rtime = mktime(&tmv);
	printf("%s msec=%d UTC:%s",tempstr,millisec,asctime(gmtime(&rtime)));
	for (i = 0; i < 3; i++)
		fgets(tempstr, 255, fp_hk[i]);
	sscanf(tempstr, "%i%f", &samples,&delt);
	deltat=irint(delt*1000.0);
	for (i = 0; i < 3; i++)
		datavec[i] = (Vector) malloc((unsigned) samples * sizeof(float));
	for (h = 0; h < 3; h++) {
		j = 0;
		while (!feof(fp_hk[h]) && fgets(tempstr, 255, fp_hk[h])) {
			for (i = 0; i < 6; i++) {
				strncpy(newstr, &tempstr[i * 12], 12);
				newstr[12] = 0;
				sscanf(newstr, "%e", &datavec[h][j++]);
			}
		}
		fclose(fp_hk[h]);
	}
	curr_point=0;
}

void tmstr_qqt5_(long *secs, long *msec, float *dsecs, char *str)
{
        ldiv_t          ldivtemp;
        struct tm       etime;
        long            temp, nsecs, nmsec;
        float           ndsecs;
 
        nsecs = *secs;
        nmsec = *msec;
        ndsecs = *dsecs;
        temp = irint(ndsecs);
        nsecs += temp;
        nmsec += irint((float) (ndsecs - temp) * 1000.0);
        ldivtemp = ldiv(nmsec, 1000);
        nmsec = ldivtemp.rem;
        nsecs += ldivtemp.quot;
        if (nmsec < 0) {
                nmsec += 1000;
                nsecs--;
        }
 
        nsecs = nsecs - 28800;
 
        memcpy(&etime, gmtime(&nsecs), sizeof(struct tm));
 
        strftime(str, 70, "%x %X", &etime);
        sprintf(str, "%s.%3.3ld GMT", str, nmsec);
        str[strlen(str)]=' ';
}

