#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <stdio.h>

/*

  This is a c routine to call from fortran to return
  the yr,mon,dy,hr,mn,sec result to a fortran routine.

  the secs and msecs are integers (longs). 

*/

void ymdhms_(long *secs, long *msec, 
            int* year, int* month, int* day,
            int* hour, int* minute, int* second)
{
	ldiv_t          ldivtemp;
	struct tm       etime;
	long            temp, nsecs, nmsec;
        time_t		azone;

	nsecs = *secs;
	nmsec = *msec;
	ldivtemp = ldiv(nmsec, 1000);
	nmsec = ldivtemp.rem;
	nsecs += ldivtemp.quot;
	if (nmsec < 0) {
		nmsec += 1000;
		nsecs--;
	}

	nsecs = nsecs - 28800; /* subtract 8 hours for local time offset */

	memcpy(&etime, gmtime(&nsecs), sizeof(struct tm));

	altzone = azone;

        *year   = etime.tm_year + 1900;
        *month  = etime.tm_mon +1;
        *day    = etime.tm_mday;
        *hour   = etime.tm_hour;
        *minute = etime.tm_min;
        *second = etime.tm_sec;
}

