#include <stdio.h>
#include <math.h>

void nrerror(str)
char *str;
{
	fprintf(stderr,"%s",str);
	exit(-1);
}
#define IGREG (15+31L*(10+12L*1582))

long julday(mm,id,iyyy)
int mm,id,iyyy;
{
	long jul;
	int ja,jy,jm;
	void nrerror();

	if (iyyy == 0) nrerror("JULDAY: there is no year zero.");
	if (iyyy < 0) ++iyyy;
	if (mm > 2) {
		jy=iyyy;
		jm=mm+1;
	} else {
		jy=iyyy-1;
		jm=mm+13;
	}
	jul = (long) (floor(365.25*jy)+floor(30.6001*jm)+id+1720995);
	if (id+31L*(mm+12L*iyyy) >= IGREG) {
		ja=0.01*jy;
		jul += 2-ja+(int) (0.25*ja);
	}
	return jul;
}


#undef IGREG
#define IGREG 2299161

void caldat(julian,mm,id,iyyy)
long julian;
int *mm,*id,*iyyy;
{
	long ja,jalpha,jb,jc,jd,je;

	if (julian >= IGREG) {
		jalpha=((float) (julian-1867216)-0.25)/36524.25;
		ja=julian+1+jalpha-(long) (0.25*jalpha);
	} else
		ja=julian;
	jb=ja+1524;
	jc=6680.0+((float) (jb-2439870)-122.1)/365.25;
	jd=365*jc+(0.25*jc);
	je=(jb-jd)/30.6001;
	*id=jb-jd-(int) (30.6001*je);
	*mm=je-1;
	if (*mm > 12) *mm -= 12;
	*iyyy=jc-4715;
	if (*mm > 2) --(*iyyy);
	if (*iyyy <= 0) --(*iyyy);
}

#undef IGREG
