/**********************************************************************

 Module:		crcfunc.c
 Program:		dpsample
 Author:		Harald Krake

 First Edition:		09/01/90

 Original Version:	derived from Joe Steims Pascal-Sources.
 Revision changes:	none.

 **********************************************************************/




/* This module contains the CRC-functions for DA-communication. */

#include "seismo.h"


/* table to speed up CRC calculations */

static	unsigned long	crc_table [256];	/* precalculated CRC-table */


/************************************
 *
 * Name: GCRCINIT
 * Func: precalculate the crc_table
 *
 ***********************************/

Gcrcinit ()
{
unsigned long	*crcp;		/* pointer to current entry in CRC-table */
short	byte_count;		/* for all bytes 0 ... 255 */
char	bit_count;		/* bits 0...7 in a byte */
unsigned long	crc;		/* computed crc-byte value */
unsigned long   lbyte;		/* byte-value in 32-bit to be shifted */



	/* for all possible 8-Bit bytes */
	for (crcp = crc_table, byte_count = 0; 
	     byte_count < 256; 
	     crcp++, byte_count++) {

	    /* make byte a 32-Bit quantity to get the MSBit */
	    lbyte = (byte_count << 24);	/* shift 3 bytes left */

	    crc = 0;			/* clear byte crc */

	    /* for all bits in a byte */
	    for (bit_count = 0; bit_count < 8; bit_count++) {

		if ((lbyte ^ crc) & 0x80000000L)
		    crc = (crc << 1) ^ CRC_POLYNOMIAL;
		else
		    crc <<= 1;

	    	lbyte <<= 1;
	    }

	    /* store precalculated byte crc in table */
	    *crcp = crc;
	}
}




/* function to calculate the CRC word.

   Usage:	unsigned long 	Gcrcvalc (b, len)
   args:	unsigned char	*b;	source buffer
		int		len;	buffer length

   returns:	the computed CRC in a long.
*/

unsigned long	Gcrccalc (buf, len)
	 	unsigned char	*buf;
	 	int		len;
{
unsigned long	crc;			/* computed returned crc-32-bit */

	crc = 0L;		/* clear return-value */

	while (len-- > 0)		/* until end of buffer */

	    /* take the most significant 8 bits from current crc-value
	       and XOR this with the next buffer byte.
	       Use this 8-Bit value (&0xff is not necessary because
	       both operands are unsigned) as an index to the
	       crc_table and get the crc-mask. Then XOR this
	       long with the current crc shifted 8 bits left. */

	    crc = crc_table [ *((unsigned char*)&crc) ^ *(buf++) ] ^ 
		  (crc << 8);

	return (crc);
}



/* This function computes a signed 16-Bit checksum
   
   Usage:	unsigned short	Checksum (addr, size)
   argas:	unsigned char *addr
		int  size

*/

unsigned short	Checksum (addr, size)
	unsigned char	*addr;
	int	size;
{
unsigned short	sum;

	sum = 0;
	while (size-- > 0)
		sum += *(addr++);

	return (sum);
}


