/************************************************************************/
/*									*/
/*	Phil Maechling							*/
/*	Seismologcal Laboratory					        */
/*	California Institute of Technology				*/
/*	phil@seismo.gps.caltech.edu					*/
/*									*/
/************************************************************************/
/*  

    Test Station Manager

    This is the test program for the
	station manager


*/

#include <stdio.h>
#include "qlib.h"
#include "sman.h"
#include "cman.h"
#include "txman.h"
#include "meter.h"


int main()
{

  char sta[4];
  char comp[4];
  char config[100];
  char sport[100];
  char sdate[100] = "92,180,11:52:00.0";
  char fdate[4];
  INT_TIME *startdate;
  INT_TIME packet_time;
  INT_TIME *curdate;
  char *outdate;
  int res;
  int secs;
  HEADER_DATA datablk; 
  INT_TIME blktime;
  FILE *netlist;


  netlist = fopen("network.dat","r");
 
  while (fscanf(netlist,"%s %s %s",sta,config,sport) == 3)
  {
    res = initialize_station(sta,config);
    if (res == 0)
    {
      fatalsyserr("Error initializing station %s\n",sta);
    }

    res = initialize_station_out_port(sta,sport);
    if (res == 0)
    {
      fatalsyserr("Error initializing serial port%s\n",sta);
    }
  }


  printf("init station res: %d \n",res);
  startdate  = parse_date(sdate);

  establish_virtual_present(*startdate);

  printf("\n\n");

  printf("Press return to start Virutal Present Meter !!!\n\n");

  gets(fdate);

  start_meter();

  curdate = virtual_present();

  outdate = time_to_str(*curdate,1);

  printf("Virtual Present : %s \n",outdate);

  while(1)
  {

    res = block_to_send(sta,comp,&datablk,&blktime);

    if (res == 1)
    {
      outdate = time_to_str(blktime,1);
      printf("Last sample in data block : %s \n",outdate);
      printf("Send block \n");
      res = send_packet(sta,comp,&datablk);
      {
        if(res == 0)
        { 
	  printf("Error on transmit\n");
        }
      }
      sleep(1);
    }
    else
    {
      printf("No data to send\n");
      curdate = virtual_present();
      outdate = time_to_str(*curdate,1);
      printf("Virtual Present : %s \n",outdate);
      sleep(1);
    }
    
  }
}
