/************************************************************************/
/*									*/
/*	Phil Maechling							*/
/*	Seismological Laboratory				        */
/*	California Institute of Technology				*/
/*	phil@seismo.gps.caltech.edu					*/
/*									*/
/************************************************************************/
/*  Station Manager

    This module interfaces to a collection of data known as a station

    When an application wants to know information about a station,
	or needs to send one, it calls functions in this package.

-----------------------------------------------------------------------


    Methods Include:


	int Initialize_station(char *,char *)
		Give this a Station name, and the
	path name to the file which contains the data for that
        station.
		0 means problems, 1 means init went fine.


	int close_station(char *)
	
		Give this program a station name, and
	assuming the file was previoulsy initialized, this
	will close the station file;
		0 means problems, 1 means reset ok.


	int block_to_send(char *,HEADER_DATA *,INT_TIME *);
	
		Give this program a station name, and
	it will return a pointer to a SEED block of data.

----------------------------------------------------------------


  Assumptions:


	Initialize station does not initialize the serial port.

*/

#include <string.h>
#include <stdio.h>
#include "qlib.h"
#include "meter.h"
#include "config.h"
#include "txman.h"


int initialize_station(char *station,char *file)
{
  FILE *stafile;
  int scanned;
  char comp[100];
  char cfile[100];
  int total = 0;
  int res;

  stafile = fopen(file,"r");
  if (stafile == NULL)
  {
    fatalsyserr("Error opening station file \n");
  }

  while (fscanf(stafile,"%s %s",comp,cfile) == 2)
  {
    /* Handle EL data as HL data */
    if (strncmp(comp,"EL",2) == 0)
    {
      memset(&comp[0],'H',1);
    }

    if (initialize_component(station,comp,cfile) !=1)
    {
       printf("Error initializing component. Unknown component type : %s \n",comp);
       return(0);
    }
    ++total;
  }
  printf("Initialized %d components for %s\n",total,station);

  return(1);
}


int close_station(char *station)
{
  int i;

  for (i=0;i<NUMBER_OF_STREAMS;i++)
  {
    close_component(*station,&streams[i]);
  }
  return(1);
}


int block_to_send(char *station,char *comp,HEADER_DATA *hd,INT_TIME *ht)
{
  HEADER_DATA packet;
  INT_TIME blktime;
  int res;
  int notfound=1;
  int streams_checked = 0;
  static int last_found = -1;
  DATA_HDR *qda;
  int blksize;

  while(notfound)
  {
    ++last_found;
    last_found= last_found%NUMBER_OF_STREAMS;

    res = packet_ready(station,&streams[last_found]);

    if (res == 1)
    {
      res = packet_to_send(station,&streams[last_found],&packet);
      if (res == 1)
      {
        qda = decode_hdr_qda((QDA_HDR *)&packet,&blksize);
        *ht = qda->endtime;
        *hd = packet;
        strcpy(comp,(char *)&streams[last_found]);
        return(1);
      }
      else
      {
        printf("Error getting packet to send. Should not happen. \n");
        return(0);
      }
    }
    else
    {
      ++streams_checked;
      if (streams_checked >= NUMBER_OF_STREAMS)
      {
        return(0);
      }
    } 
  }/* end while not found */
}
