/*
 * File:    steim.h
 *          header file for steim compression/decompression at levels 1,2,3
 */

#include <stdio.h>
#include <string.h>


#define LONG        long
#define SHORT       short
#define CHAR        char
#define WORD        unsigned short
#define FLOAT       double
#define BOOLEAN     int
#define UCHAR       unsigned char
#define REGISTER


#ifdef sun
#ifndef __STDC__
#define  const            static
#endif
#define  labs             abs
#endif

#ifdef OSK
#define  const            static
#define  labs             abs
#define  void
#undef   REGISTER
#define  REGISTER         register
#endif

#ifndef  TRUE
#define  TRUE             1
#define  FALSE            0
#endif


  /*
   * *****************************************************************
   * the following group of definitions is needed for compression.   *
   * the conditional "STATISTICS", and code it controls may be       *
   * omitted from "production" compression code, in which histograms *
   * of what differences fit in how many bits are not needed.        *
   * *****************************************************************
   */

#define STATISTICS  1



  /*
   * to simplify buffer wrap handling, 
   * PEEKELEMS should be set to at least the largest
   * number of samples (N) to be written to the buffer + 143, 
   * the maximum number of samples
   * in a level 3 frame. this is really only a convenience 
   * for the peek buffer management
   * routines in this module. as long as the user does not 
   * overflow the peek buffer, and keeps
   * it sufficiently full that no samples are "padded" by 
   * compress_frame, the peek buffer
   * can be filled any way you like.
   */


#define    PEEKELEMS           150
#define    WORDS_PER_FRAME     16
#define    MAXSAMPPERWORD      9
#define    ICONSTCODE          0xE0000000
#define    ICONSTMASK          (~ICONSTCODE)
#define    ICONSTSIGN          (((LONG)ICONSTMASK+1) >> 1)
#define    NOTDIFFERENCE       0xC8000000
#define    SECONDDIFF          0x80000000
#define    REPLACEMENTMASK     0x70000000


  typedef union {
      CHAR                  b[4] ;
      SHORT                 s[2] ;
      LONG                  l ;
    } COMPWORD ;


  typedef LONG              peekbuffertype[PEEKELEMS];

  typedef COMPWORD          compressed_frame[WORDS_PER_FRAME];

  typedef compressed_frame  *cfp;



    typedef struct {
        SHORT                 next_in ;
        SHORT                 peek_total, next_out ;
        LONG                  frames ;
        LONG                  last_1, last_2, final ;
        peekbuffertype        *peeks ;
#ifdef STATISTICS
        LONG                  squeezed_flags ;
        LONG                  fits[33] ;
#endif
        compressed_frame      framebuf ;
        SHORT                 peek_threshold ;
      } compression_continuity ;


    typedef compression_continuity *ccptype ;


    typedef struct {
        ccptype               ccp ;
        SHORT                 bestdiff ;
        SHORT                 difference ;
        SHORT                 trials ;
        SHORT                 firstframe ;
        SHORT                 framespertrial ;
        SHORT                 framesperpackage ;
        SHORT                 level ;
        SHORT                 flip ;
      } adaptivity_control ;

    typedef adaptivity_control *adptype ;

  /*
   * ****************************************************************
   * the following group of definitions is needed for decompression *
   * ****************************************************************
   */

#define     UNPACKSIZE          150
#define     UNPACKFINAL         (UNPACKSIZE-2)

  /*
   * the following status codes are returned by "decompress_frame".
   * EDF_OK implies fully correct decompression, including check of
   *        integration constants.
   * EDF_INTEGRESYNC implies a non-fatal advisory, 
   * such as successful resynchronization
   *        at the integration constant check following a descrepancy,
   *        such as when one or more records are missing.
   * others imply an internally corrupt frame. this may arise also from
   *        decompression at the wrong level.
   * the status code masked with EDF_FATAL returned by 
   * decompress frame may be checked
   *        to test for failure to decompress.
   * the status code masked with EDF_NONFATAL returned by 
   * decompress frame may be checked
   *        to test for advisory status, such as integration constant resync.
   */

#define     EDF_OK              0x00
#define     EDF_INTEGRESYNC     0x01
#define     EDF_INTEGFAIL       0x02
#define     EDF_SECSUBCODE      0x04
#define     EDF_TWOBLOCK        0x08
#define     EDF_OVERRUN         0x10
#define     EDF_REPLACEMENT     0x20
#define     EDF_LASTERROR       0x40
#define     EDF_COUNTERROR      0x80
#define     EDF_FATAL  (EDF_INTEGFAIL|EDF_SECSUBCODE|EDF_TWOBLOCK|EDF_OVERRUN|EDF_REPLACEMENT)
#define     EDF_NONFATAL        (EDF_INTEGRESYNC|EDF_LASTERROR|EDF_COUNTERROR)


  typedef  LONG         unpacktype[UNPACKSIZE] ;

  typedef  SHORT        *sptype ;

  typedef struct {
      LONG      samp_1 ;
      LONG      samp_2 ;
      SHORT     numdecomp ;
    } decompression_continuity ;

  typedef   decompression_continuity *dcptype ;


  /*
   * the following structures allow build complete "records", 
   * which comprise a GENERICHDRL-byte
   * header, followed by up to (MAXTOTALFRAMESPERRECORD-1) 64-byte 
   * compressed "frames".
   * a pointer to such a "generic_data_record" may be cast to point 
   * to SEED data records,
   * or NSN data records, or whatever, while allowing all the 
   * compression library functions
   * not to care what kind of header will be installed. 
   * you should set GENERICHDRL
   * to the size of headers on the types of actual data records 
   * you're using, bearing in mind that
   * "frames" must begin at least on a "long" boundary.
   */

#define MAXTOTALFRAMESPERRECORD         64
#ifndef GENERICHDRL
#define GENERICHDRL                     64
#endif

  typedef struct {
      CHAR                              head[GENERICHDRL] ;
      compressed_frame                  frames[MAXTOTALFRAMESPERRECORD-1] ;
    } generic_data_record ;


  typedef struct {
      adptype                           adp ;
      generic_data_record               *gdr ;
      LONG                              nsamples ;
    } generic_data_record_control ;

  typedef generic_data_record_control   *gdptype ;


    /*  -------------------- END OF STEIM.H ------------------------ */
