/*
 * Module : titem.c
 *
 *
 *
 * Purpose of Module :
 *
 *  This program reads an ISAIAH message from a socket, converts that
 *  message into an event structure and calls findnetmags.c 
 *
 *  This program creates the server part of a client-server pair.
 *  This will run on the Unix side of the channel.
 *
 * Comments : 
 *  To compile and link this server:
 *
 *    $ cc server.c -lsocket -lnsl
 *
 * Author : Phil Maechling
 *
 * Last Modification : 12 July 94
 *
 */

#include <sys/types.h>
#include <time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <unistd.h>   /* Include for sleep function */
#include "terramag.h"
#include "chron.h"

extern double tnow();
extern long julmin();
extern int network_magnitude();
extern int qevent_to_belt_page();
extern int zero_qevent();
extern void make_event_final(struct q_event_type *qevent);
extern int event_was_finalized(struct q_event_type *qevent);
extern void clear_event_array();


float mincalcmag = 2.5;
float minpagemag = 3.5;

int main(int argc, char *argv[])
{

int s_read;
struct sockaddr_in server_r;
struct hostent *hp;
char inbuf[BYTES_IN_PACKET + 1];
char outbuf[BYTES_IN_PACKET];
char idata[FILE_NAME_LENGTH],tdata[FILE_NAME_LENGTH]; 
int status,status1;
int r_socket;
struct event_data_type event_data;
int iyear,imonth,iday,ihour,iminute,isecond;
float flat,flong,fdepth;
float fmag;
int identity;
float rml,mlrms,rme,merms; /*returned ml and ml rms */
int nml,nme;               /* Number of ml's and me's used in mag */
struct Greg g;
long event_julian_min;
double event_julian_seconds;
double current_julian_seconds;
FILE *cat_fp,*elist_fp,*finals_fp;
char fname[20];
char beltpage[LENGTH_OF_PAGE + 1];
struct q_event_type qevent;
char deststr[12];
FILE *minmagf;
int dataread;
char mode;
char verbose;

char sta[STATION_NAME_SIZE];
char *stationfile;
FILE *sta_fp;
struct station_list_type stalist;
char line[FILE_NAME_LENGTH];
int  fstatus;
char sysline[FILE_NAME_LENGTH];


  if (argc != 2)
  {
    printf("\n");
    printf("Usage  : item <computer> \n");
    printf("Example: item cajon \n");
    printf("\n");
    exit(0);
  }

/* 
* Read minimum magnitude from file 
*/


  minmagf = fopen(MINMAGFILE,"r");

  if (minmagf == NULL)
  {
    syserr("Error opening Min Mag file\n");
    mincalcmag = 2.5;
    minpagemag = 3.5;
  }
  else
  {  
    dataread = fscanf(minmagf,"%f %f",&mincalcmag,&minpagemag);
    if (dataread != 2)
    {
      syserr("Error reading Min mag\n");    
      mincalcmag=2.5;
      minpagemag=3.5;
    }
  }

  printf("New minimum calc magnitude : %2.2f\n",mincalcmag);
  printf("New minimum page magnitude : %2.2f\n",minpagemag);
 
  fflush(stdout);
/*
 Clear the finalized event array 
*/

clear_event_array();

/*
 * Read in the station list 
 *
 */

 stationfile = getenv("NETWORK_STATIONS"); 
 sta_fp = fopen(stationfile,"r");
 if (sta_fp == NULL)
 {
   fatalsyserr("NETWORK_STATIONS file open failed in atem.\n");
 }  

 stalist.number_of_stations = 0;

 while (fgets(line,EV_LINE_LEN,sta_fp) != NULL)
 {
   status = sscanf(line,"%s",&sta);
   if(status < 1)
   {
     fatalsyserr("Scanf error reading stations list in atem.\n");
   }

   memcpy(&stalist.stations[stalist.number_of_stations],
		sta,STATION_NAME_SIZE);

   stalist.number_of_stations++;

 }

/*
 * This call returns some complicated structure representing the
 * IP address of Cajon.
 *
 */

  hp = gethostbyname(argv[1]);

  if (hp == (struct hostent *) 0) 
  {
    printf("Host is unknown to on client machine.\n");
    fatalsyserr("Error on gethostbyname\n");
  }

/*
* Start to assemble the internet address data structure (type saockaddr_in)
*/

  server_r.sin_family = AF_INET;

/*
* Move part of the returned address into the address needed for 
* the connect call.
*/
  memcpy ( (char *) &server_r.sin_addr, (char *) hp->h_addr,
                  hp->h_length );
/*
 *
 * The SOCK_STREAM parameter says we want a reliable, connection 
 * oriented comm link. The other choice is SOCK_DGRAM which would
 * give you unreliable comm.
 *
 */

  for(;;)
  {

    r_socket = FALSE;

    while (r_socket == FALSE)
    {
       s_read = socket(AF_INET, SOCK_STREAM, 0);

       if (s_read < 0) 
       {
         printf("Error opening socket s_read.\n");
         fatalsyserr("Error opening Socket\n");
       }

       server_r.sin_port = htons(READ_LOCATION_SERVICE);

/*
*  The server must be running and sitting on an accept function call.
*/


       if ( connect( s_read, (struct sockaddr *) &server_r, 
         sizeof (server_r) ) < 0)
       {
         printf("s_read connect attempt failed.\n ");
         sleep((unsigned) CONNECT_RETRY_DELAY);
       }
       else
       {
         r_socket = TRUE;
       }

   } /* End while socket read is FALSE */


   sleep(30);
   /* Socket connected. Now Read data */


   while (r_socket == TRUE) 
   {
      status = 0;
      status1 = 0;

      status = recv(s_read,inbuf,BYTES_IN_PACKET,0);
      if (status <= 0)
      {
        r_socket = FALSE;
      }

      /* This second loop makes sure we have read the right
         number of bytes */

      while ( (status < BYTES_IN_PACKET) && (r_socket == TRUE) )
      {
        status1 = recv(s_read,&inbuf[status],(BYTES_IN_PACKET - status),0);
        if (status1 <= 0)
        {
          r_socket = FALSE;
        }
       status +=status1;
      }

     /* All bytes read. Now scan for fields of interest */

     memcpy(&inbuf[BYTES_IN_PACKET -1],"\0",1);

     printf("String length inbuf %d\n",strlen(inbuf));
     printf("Data : %s ",inbuf);
     fflush(stdout);

/*      rtpmsg_to_qevent(inbuf,qevent); */

     if (sscanf(inbuf,"%d %d %d %d %d %d %f %f %f %f %d",
     &iyear,&imonth,&iday,&ihour,&iminute,&isecond,
     &flat,&flong,&fdepth,
     &fmag,
     &identity) < 11)
     {
       printf("Error on scanf \n");
       r_socket = FALSE;
       continue;
     }

/* Load qevent structure */

     zero_qevent(&qevent);
     strcpy(qevent.message_type,"Event");
     qevent.event_id=identity;
     strcpy(qevent.data_source,"Pasadena");
     qevent.event_version=1;
     qevent.year=iyear;
     qevent.month=imonth;
     qevent.day=iday;
     qevent.hour=ihour;
     qevent.minute=iminute;
     qevent.second=isecond;
     qevent.latitude=flat;
     qevent.longitude=flong;
     qevent.depth= (-1) * fdepth;
     qevent.magnitude=fmag;

     if (fmag < mincalcmag)
     {
      printf("Under min mag\n");
      continue;
     }
     else
     {
       event_data.lat         = flat;
       event_data.lon         = flong;
       event_data.depth       = (-1) * fdepth;
       event_data.date.year   = iyear; 
       event_data.date.month  = imonth; 
       event_data.date.day    = iday;
       event_data.date.hour   = ihour;
       event_data.date.minute = iminute;
       event_data.date.second = isecond;
       event_data.date.msec   = 0;
      printf("Over min mag\n");

     } /* end of IF (mag is less than minimum mag) */

   } /* End while sockets are TRUE */

    close(s_read);

    r_socket = FALSE;

    sleep(10);

  } /* End forever for loop */

}
