/************************************************************************/
/*									*/
/*	Phil Maechling							*/
/*	Seismological Laboratory		       		        */
/*	California Institute of Technology				*/
/*	phil@seismo.gps.caltech.edu					*/
/*									*/
/************************************************************************/
/*  

    isend

	Isaiah service

	This routine, checks for the exisitance of a event message
	to be sent to item.

	The event messages are /tmp/event.dat

	When it finds one, it sends it out stdout as a block write
	of 100 characters.

	Then item, gets the location, and thinks its from ISAIAH and
	processes the data as if it was an ISAIAH location.

	This needs to be installed as a sevice on the unix machine.
	Then the service that item connects to must be made to point
	to this executable.

*/

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <errno.h>


int main()
{

  FILE *efile;
  int res,len;
  char outbuf[102];
  char inbuf[100];


  while(1)
  {

    res = system("test -r /tmp/event.dat");
    if (res == 0) /* 0 is true in this case */
    {
      efile = fopen("/tmp/event.dat","r");
      if (efile == NULL)
      {
        printf("Error opening event.dat file\n");
        exit(-1); 
      }  
      fgets(inbuf,sizeof(inbuf),efile);

      fclose(efile);

      /* remove the file . Ready for next event */

      res = remove("/tmp/event.dat");
      if (res != 0)
      {
        printf("Error deleting event.dat file \n");
        exit(1);
      }

      len = strlen(inbuf);
      memcpy(outbuf,inbuf,len);
      memset(&outbuf[len],0x20,(sizeof(outbuf) - len) - 1);

      if ( send(0,outbuf,101,0) != 101 )
      {
          printf("Error writing to socket.\n");
          exit(1);
      }    
    }/* Done with processing when file is found */

    sleep(1);
  }
}
