#include <stdio.h>
#include "terramag.h"

/*

  This is routine that keeps a list of finalized events.
  When an event is input to item, it is checked against
  the finalized list.

  If the event is on the list, and if the latitude, and
  longitude match the exisiting data, then the event
  is not reprocessed.

*/

extern void make_event_final(struct q_event_type *qevent);
extern int event_was_finalized(struct q_event_type *qevent);
extern void clear_event_array();

static struct q_event_type event_array[NUMBER_OF_FINALIZED_EVENTS];

void clear_event_array()
{
  int icnt;

  for(icnt=0;icnt<NUMBER_OF_FINALIZED_EVENTS;icnt++)
  {
    event_array[icnt].event_id = 0;
  }
  return;
}

void make_event_final(struct q_event_type *qevent)
{
  static int next_event = 0;

  if (next_event==NUMBER_OF_FINALIZED_EVENTS)
  {
    next_event = 0;
  }

  event_array[next_event] = *qevent;
  next_event++;
  return;

}

int event_was_finalized(struct q_event_type *qevent)
{
  int icnt;

  for (icnt=0;icnt<NUMBER_OF_FINALIZED_EVENTS;icnt++)
  {
    if ( (event_array[icnt].event_id == qevent->event_id) &&
         (event_array[icnt].latitude == qevent->latitude) &&
         (event_array[icnt].longitude == qevent->longitude) )
    {
         return(1); /* return true. event was finalized */
    }
  }

  return(0); /* event not on list so it was not finalized */

}

