/************************************************************************/
/*									*/
/*	Phil Maechling							*/
/*	Seismological Laboratory				        */
/*	California Institute of Technology				*/
/*	phil@seismo.gps.caltech.edu					*/
/*									*/
/************************************************************************/
/*  

    rerun

    This is the top level program that runs the simulation test.


*/

#include <stdio.h>
#include "qlib.h"
#include "ndman.h"
#include "neman.h"
#include "meter.h"


int main()
{

  char sta[4];
  char config[100];
  char sport[100];
  char idate[100];
  char sdate[100] = "92,180,11:50:00.0";
  char fdate[4];
  char netfile[100] = "network.dat";
  INT_TIME *startdate;
  INT_TIME packet_time;
  INT_TIME *curdate;
  char *outdate;
  int res;
  int secs;
  HEADER_DATA datablk; 
  INT_TIME blktime;
  FILE *netlist;
  int sentdata = 0;


/* Start of rerun main program */

  initialize_network(netfile);

  initialize_network_event_manager();

  initialize_virtual_time_meter();
  printf("\n\n");
  printf("Enter the \"virtual\" time that the simulation is to begin. \n"); 
  printf("Enter data and time in this format. (yy,doy,hh:mm:ss:ss.ffff) \n");
  printf("<CR> starts simulation prior to Landers mainshock (92,180,11:50:00.0) \n\n");

  gets(idate);

  if ( strcmp(idate,"") == 0 )
  {
    printf("Using default start time : 92,180,11:50:00.0\n");
  }
  else
  {
    strcpy(sdate,idate,sizeof(idate));
  }


  startdate  = parse_date(sdate);

  if(startdate == NULL)
  {
    printf("Error parsing start time : %s \n",idate);
    exit(0);
  }

  establish_virtual_present(*startdate);



  startdate  = parse_date(sdate);

  establish_virtual_present(*startdate);

  printf("\n\n");

  printf("Press return to start Virutal Present Meter !!!\n\n");

  gets(fdate);

  start_meter();

  curdate = virtual_present();

  outdate = time_to_str(*curdate,1);

  printf("Virtual Present : %s \n",outdate);

  sentdata = 0;

  while(1)
  {


    res = send_network_trace_data();
    if (res == 1)
    {
      sentdata = 1;
    }


    res = send_network_detection_data();
    if (res == 1)
    {
      sentdata = 1;
    }


    res = send_isaiah_event();
    if (res == 1)
    {
      sentdata = 1;
    }



    /*

       Here check if anything was sent. If it was, go back and attempt to 
       send immediately. Otherwise, print the time and sleep for a second.

    */


    if (sentdata == 1)
    {
      sentdata = 0;
    }
    else
    {
      curdate = virtual_present();
      outdate = time_to_str(*curdate,1);
      printf("Virtual Present : %s \n",outdate);
      sleep(1);
    }
  }
}
