/************************************************************************/
/*									*/
/*	Phil Maechling							*/
/*	Seismological Laboratory		       		        */
/*	California Institute of Technology				*/
/*	phil@seismo.gps.caltech.edu					*/
/*									*/
/************************************************************************/
/*  

    Test Component manager

    This is the test program for the
	component manager



*/
#include <stdlib.h>
#include <stdio.h>
#include "qlib.h"
#include "neman.h"
#include "meter.h"



int main()
{

  char sdate[100] = "92,180,11:55:45.0";
  char fdate[100];
  INT_TIME *startdate;
  INT_TIME packet_time;
  INT_TIME *curdate;
  char *outdate;
  int res;
  int secs;
  HEADER_DATA datablk; 
  char eventline[120];

  res = initialize_network_event_manager();
  printf("init res: %d \n",res);

  printf("Enter Time simulation is to begin : (yy/mm/hh:mm:ss:ss.ffff)");

  startdate  = parse_date(sdate);

  establish_virtual_present(*startdate);

  printf("Press return to start Virutal Present Meter !!!\n");

  gets(fdate);

  start_meter();

  curdate = virtual_present();

  outdate = time_to_str(*curdate,1);

  printf("Virtual Present : %s \n",outdate);

  while(1)
  {
    res = send_isaiah_event();
    if (res == 0)
    {
      printf("Sleeping because there was nothing to send\n");
      sleep(1);
    }
    else
    {
      printf("Event sent\n");
    }
    printf("Checking for new event\n");
 
  } /* end endless loop */
}
