/***********************************************************************/
/*									*/
/*	Phil Maechling				         		*/
/*	Seismological Laboratory				        */
/*	California Institute of Technology				*/
/*	phil@seismo.gps.caltech.edu					*/
/*									*/
/************************************************************************/
/*  


	Network Isaiah Event Manager


    When an application wants to know information about an event,
	or needs to send one, it calls functions in this package.


-----------------------------------------------------------------------


    Methods Include:


	int initialize_network_event_manager()

		This looks in the event.dat file to find
	the catalog name and the telemetry delay. Then it
	calls the initialize_event_manager routine.
		0 means problems, 1 means init went fine.


	int send_isaiah_event()

		This is the high level routine that is
	called from the rerun program.


----------------------------------------------------------------


  Assumptions:

   
*/


#include <string.h>
#include <stdio.h>
#include <sys/types.h>
#include <time.h>
#include "qlib.h"
#include "meter.h"
#include "network.h"
#include "time.h"
#include "eman.h"


int initialize_network_event_manager()
{

  FILE *infile;
  char filename[100];
  int delay;  
  int res;


  infile = fopen("config.qck","r");
  if (infile == NULL)
  {
    fatalsyserr("Error opening event list\n");
  }

  res = fscanf(infile,"%s %d",filename,&delay);

  if (res != 2)
  {
    syserr("Error reading event configuration file.\n");
    return(0);
  }

  res = initialize_isaiah_event_list(filename,delay);
  
  if(res == 1) 
  {
    return(1);
  }
  else
  {
    return(0);
  }
}

/* 

  Return 0 if nothing sent. Return 1 if something sent

*/

int send_isaiah_event()
{

  int res;
  char eline[120];
  char sysline[200];
  FILE *outfile; 
  time_t curtime;
  static time_t lasttime;
  static int firsttime = 1;


  if (firsttime)
  {
    lasttime = time(NULL);
    firsttime =0;
  }


  if (event_ready())
  {
    res = event_to_send(eline);
    if (res == 0)
    {
      printf("Error getting event to send. Quitting\n");
      exit(0);
    }
    else
    {

      curtime = time(NULL);

      while ( (curtime -lasttime) < 4)
      {
        sleep(1);
        curtime = time(NULL);
      }
     
      lasttime = time(NULL);
 
      outfile = fopen("/tmp/event.dat","w");
      if (outfile == NULL)
      {
        fatalsyserr("Error opening event.dat\n");
      }
      fprintf(outfile,"%s\n",eline);
      fclose(outfile);
      printf("ISAIAH location sent \n");
      printf("%s\n",eline);
      return(1);
    } 
  }
  else /* event not ready */
  {
    return(0);
  }
 
}

