/************************************************************************/
/*									*/
/*	Phil Maechling							*/
/*	Seismologcal Laboratory					        */
/*	California Institute of Technology				*/
/*	phil@seismo.gps.caltech.edu					*/
/*									*/
/************************************************************************/
/*  Test Virtual Present Meter



    This is the test program to the the 
	virtual present meter



*/

#include <stdio.h>
#include "qlib.h"
#include "meter.h"

int main()
{

  char sdate[100];
  char edate[100];
  char fdate[100];
  INT_TIME *startdate;
  INT_TIME *eqdate;
  INT_TIME *curdate;
  char *outdate;
  int secs;


  initialize_virtual_time_meter();

  printf("Enter Time simulation is to begin : (yy/mm/hh:mm:ss:ss.ffff)");

  gets(sdate);

  printf("Enter time earthquake is to begin : (yy/mm/hh:mm:ss:ss.ffff)");

  gets(edate);

  startdate  = parse_date(sdate);

  establish_virtual_present(*startdate);

  printf("Press return to start Virutal Present Meter !!!\n");

  gets(fdate);

  start_meter();

  sleep(10);

  curdate = virtual_present();

  outdate = time_to_str(*curdate,1);

  printf("Virtual Present : %s \n",outdate);

  eqdate  = parse_date(edate);

  secs = seconds_until_this_virtual_time(*eqdate);

  printf("Time till eq : %d \n",secs);

  while (secs > 0)
  {

    secs = seconds_until_this_virtual_time(*eqdate);

    printf("Time till eq : %d \n",secs);
    sleep(2);
  }

  return(0);

}
