/***********************************************************************/
/*									*/
/*	Phil Maechling							*/
/*	Seismological Laboratory				        */
/*	California Institute of Technology				*/
/*	phil@seismo.gps.caltech.edu					*/
/*									*/
/************************************************************************/

/*  Network structures file

    This file contains the structures and storage for the 
	staion and component data used in the rerun software.

	FILE:

	network.h

*/

#include <string.h>
#include <stdio.h>
#include "qlib.h"
#include "config.h"

struct serial_port_data
{
  char *portname;
  int  port_descriptor;
};

struct component_data
{
  char *filename;
  FILE *infile;
  HEADER_DATA next_packet;
  int data_ready;
};

struct detection_stream
{
  FILE *infile;
  char stream[4];
  INT_TIME dtime;
  int  maxamp;
  int  data_ready;
};

struct station_data
{
  char *filename;
  FILE *infile;
  struct serial_port_data port_data;
  struct component_data comp_array[NUMBER_OF_STREAMS];
  struct detection_stream detections;
  int seq_no;
};

struct isaiah_data
{
  FILE *infile;
  char event_line[120];	
  int data_ready;
  struct tm event_time;
  int location_delay;
};

static struct station_data network[NUMBER_OF_STATIONS];
static struct isaiah_data isaiah;

