/************************************************************************/
/*									*/
/*	Phil Maechling							*/
/*	Seismological Laboratory		       		        */
/*	California Institute of Technology				*/
/*	phil@seismo.gps.caltech.edu					*/
/*									*/
/************************************************************************/
/*  

    Test Component manager

    This is the test program for the
	component manager



*/
#include <stdlib.h>
#include <stdio.h>
#include "qlib.h"
#include "eman.h"
#include "meter.h"



int main()
{

  char sdate[100] = "92,180,12:52:30.0";
  char fdate[100];
  INT_TIME *startdate;
  INT_TIME packet_time;
  INT_TIME *curdate;
  char *outdate;
  int res;
  int secs;
  HEADER_DATA datablk; 
  char eventline[120];

  res = initialize_isaiah_event_list("quake.dck",180);
  printf("init res: %d \n",res);

  printf("Enter Time simulation is to begin : (yy/mm/hh:mm:ss:ss.ffff)");

  startdate  = parse_date(sdate);

  establish_virtual_present(*startdate);

  printf("Press return to start Virutal Present Meter !!!\n");

  gets(fdate);

  start_meter();

  curdate = virtual_present();

  outdate = time_to_str(*curdate,1);

  printf("Virtual Present : %s \n",outdate);

  res = event_ready();
  printf("event ready %d\n",res);

  sleep(1);

  while(1)
  {
    if ( event_ready() < 1 )
    {
      printf("No data to send.\n");
      sleep(2);
    }
    else
    {
      res = event_to_send(eventline);
      if (res == 0)
      {
        printf("Error on packet to send. Null block\n");
        exit(0);
      }
      else
      {
        printf("Event data : %s \n",eventline);
        sleep(1);
      }
    }
  } /* end endless loop */
}
