/***********************************************************************/
/*									*/
/*	Phil Maechling							*/
/*	Seismological Laboratory				        */
/*	California Institute of Technology				*/
/*	phil@seismo.gps.caltech.edu					*/
/*									*/
/************************************************************************/
/*  Detection Manager

    This object interfaces to a file of detection messages . In this case,
	a detection consists of a stream, and amplitude, and a time.
        the station the detection is for is associated by the file
	the detection is in, with one file per station.

-----------------------------------------------------------------------


    Methods Include:


	int initialize_detection_manager(char *stationname, char *filename)

		Give this a procedure a station name, and a file name.
        The file contains a list of dections times, their amplitudes, and
	the stream for which the detection occured.
		0 means problems, 1 means init went fine.


	int detection_ready(char *stationname)

		Call this program and it will return 1 if it has
	a detection to send for the indicated station, that is, 
        if the next detection is current,
	past the virtual present at least the detection delay number
	of seconds, which is currently set to 10 seconds.

	int detection_to_send(char *sta_name,INT_TIME *,component,amplitude)
	
	It will return 1 if packet to send, 0 if no data.
	The header_data and int_time parameters are out parameters,
	and they will be filled in by the subroutine and 
	be returned.
		0 means problems, 1 means call went ok.

----------------------------------------------------------------


  Assumptions:

   
*/

#include <string.h>
#include <stdio.h>
#include "qlib.h"
#include "meter.h"
#include "network.h"
#include "time.h"



int initialize_detection_manager(char *staname, char *filename)
{

  int stanum;

  stanum = find_my_station(staname);
  if (stanum == -1)
  {
    printf("init detect manager can't find station %s\n",staname);
    return(0);
  }

  network[stanum].detections.infile = fopen(filename,"r"); 
  if (network[stanum].detections.infile == NULL)
  {
    fatalsyserr("Error opening detection list\n");
  }

  return(1);

}


/* 
   Input the station. Return 0 if no data is ready to
   be sent. Return 1 if data is ready to be sent.
*/

/*
int detection_ready(char *staname)
{

  INT_TIME last_data_time;
  int res;
  int stanum;

  stanum = find_my_station(staname);
  if (stanum == -1)
  {
    printf("detect ready manager can't find station %s\n",staname);
    return(0);
  }


  if (!network[stanum].detections.data_ready)
  {
    read_next_detection(staname);
  }
*/
  /* 
     this test fails if it tried to read data above, but
     it was out of data
  */
/*
  if (!network[stanum].detections.data_ready)
  {
    return(0);
  }

  
  if ( seconds_until_this_virtual_time(network[stanum].detections.dtime)
       (network[stanum].detections.dtime) + 10) >1) 
  {
    return(0);
  }
  else
  {
    return(1);
  } 

}
*/


int detection_to_send(char *staname,
                      INT_TIME *etime, 
                      char *stream,
                      int *maxamp)
{

  int stanum;

  stanum = find_my_station(staname);
  if (stanum == -1)
  {
    printf("detect ready manager can't find station %s\n",staname);
    return(0);
  }

  if (!network[stanum].detections.data_ready)
  {
    read_next_detection(staname);
  }

  if (!network[stanum].detections.data_ready)
  {
    return(0);
  }


  if ((seconds_until_this_virtual_time
       (network[stanum].detections.dtime) + 10) >1) 
  {
    return(0);
  }
  else
  {
    strcpy(stream,network[stanum].detections.stream);
    *etime = network[stanum].detections.dtime;
    *maxamp = network[stanum].detections.maxamp;
    network[stanum].detections.data_ready = 0;
    return(1);
  }

}


/*
   Return 1 if data has been place int next_data.
   Return 0 if no more data is available 
*/


int read_next_detection(char *staname)
{
  int numread;
  char eline[120];
  int res;
  char *thisfile; 
  char sdate[100];
  int maxamp;
  char stream[4];
  int stanum;
  INT_TIME *tdate;


  stanum = find_my_station(staname);
  if (stanum == -1)
  {
    printf("detect ready manager can't find station %s\n",staname);
    return(0);
  }


  thisfile = fgets(eline,sizeof(eline),network[stanum].detections.infile);

  if (thisfile == NULL)
  {
    network[stanum].detections.data_ready = 0;
    return(0);
  } 

  res = sscanf(eline,"%s %s %d",sdate,stream,&maxamp);

  if (res != 3)
  {
    printf("Error reading events.list file. error on scanf\n");
    network[stanum].detections.data_ready = 0;
    return(0);
  }
  
  tdate = parse_date(sdate);
  if (tdate == NULL)
  { 
    printf("Error parsing date in detection manager\n");
    network[stanum].detections.data_ready = 0;
    return(0);
  } 
  else
  {
    strcpy(network[stanum].detections.stream,stream);
    network[stanum].detections.maxamp = maxamp;
    network[stanum].detections.dtime = *tdate;
    network[stanum].detections.data_ready = 1;
    return(1);
  }
}


/* Find Station converts the SEED name to an integer */
/* A negative number means not found */

int find_my_station(char *station)
{
  
  int i;
  
  for(i=0;i<NUMBER_OF_STATIONS;i++)
  {
    if ( (strncmp(&stations[i][0],station,3) == 0) )
    { 
      return(i);
    }
  }
  return(-1);
}

