/************************************************************************/
/*									*/
/*	Phil Maechling							*/
/*	Seismological Laboratory		       		        */
/*	California Institute of Technology				*/
/*	phil@seismo.gps.caltech.edu					*/
/*									*/
/************************************************************************/
/*  

    Test Component manager

    This is the test program for the
	component manager



*/

#include <stdio.h>
#include "qlib.h"
#include "cman.h"
#include "meter.h"

int main()
{

  char sdate[100] = "92,180,11:52:00.0";
  char fdate[100];
  INT_TIME *startdate;
  INT_TIME packet_time;
  INT_TIME *curdate;
  char *outdate;
  int res;
  int secs;
  HEADER_DATA datablk; 

  res = initialize_component("PAS","BHZ","data.drm");
  printf("init res: %d \n",res);

  printf("Enter Time simulation is to begin : (yy/mm/hh:mm:ss:ss.ffff)");

  startdate  = parse_date(sdate);

  establish_virtual_present(*startdate);

  printf("Press return to start Virutal Present Meter !!!\n");

  gets(fdate);

  start_meter();

  curdate = virtual_present();

  outdate = time_to_str(*curdate,1);

  printf("Virtual Present : %s \n",outdate);

  res = time_of_next_packet("PAS","BHZ",&packet_time);

  if (res == 0)
  {
    printf("Error getting time of next packet\n");
    exit(0);
  }

  outdate = time_to_str(packet_time,1);

  printf(" Packet data end time : %s \n",outdate);

  secs = seconds_until_this_virtual_time(packet_time);

  printf("Time till next data transmission : %d \n",secs);

  res = packet_ready("PAS","BHZ");
  printf("packet ready %d\n",res);

  sleep(1);

  while(1)
  {
    if ( packet_ready("PAS","BHZ") < 1 )
    {

      res = time_of_next_packet("PAS","BHZ",&packet_time);  
      if (res == 0)
      {
        printf("Error getting time of next packet\n");
        exit(0);
      } 
      outdate = time_to_str(packet_time,1);
      printf("Time of last sample in packet : %s \n",outdate);

      secs = seconds_until_this_virtual_time(packet_time);

      printf("Time till next data : %d \n",secs);
      sleep(2);
    }
    else
    {
      res = packet_to_send("PAS","BHZ",&datablk);
      if (res == 0)
      {
        printf("Error on packet to send. Null block\n");
        exit(0);
      }
      else
      {
        printf("Block sent\n");
        sleep(1);
      }
    }
  } /* end endless loop */
}
