c   Gutenberg (2)  ("realtime" mode)
c   uses sliding window long-term and short term average for S pick,
c   if failed, then uses max amp. criterion to pick S.
c   7/13/1994  H. Kanamori
c   Modified 7/27/1994  E. Larson to use real-time routines
      character id1*70, id2*70, tmpout*10
      character timest*25,station*40
      integer ipage
      dimension  xz(13000),xn(13000),xe(13000),yn(13000),ye(13000)
      dimension  xza(250), xna(250), xea(250)
      dimension  yz(13000)
      dimension  yt(13000)
      dimension  dxz(13000), dxt(13000)
      dimension  e(13000),sav(13000),alav(13000),rat(13000)
      dimension  et(13000),savs(13000),alavs(13000),rats(13000)
      dimension  azm(250), aih(250)
      ndim=13000-2000
      tmpout='tempmail'
      open(15,file='c_qqt5')
      iwrite=1
      d2r=0.01745329
c --- read parameters ------
      read(15,*) c0, pthr
c     c0 converts counts to cm/s.  approximately 9.62e-8
c     pthr= threshold P amp for detection
      read(15,*) t0,t0s,tampav,p1,tswdmax, tazm,tampsav
      read(15,*)  tlas, tsas, delts, telf
      read(15,*)  cf1,  cf2
c t0=duration of the data in the beginning to establish base line etc.
c t0s-duration of the data to establish the long-term average after P
c tampav=duration of data to be used to determine the average p amplitude
c p1 determines the length of data to be skipped and used for S detection (after P detection)
c tswdmax  maximum duration for S window, usually 30 to 35 sec.
c tazm=duration od data for azimuth determination
c tazm is also used for Vertical/Horizontal, and glitch test for P pick
c tampsav=duration of data to be used for S amp determination
c tlas=duration of data for long-term average, tsas=duration for short-term average
c delts=allowable S time difference in Max. amp S pick
c telf=threshold frequency for "teleseismic filter", should be around 1 Hz
c if average freq. of P is lower than telf, the events is judged teleseismic
c cf1=threshold ratio for Vert/Horiz. for P
c cf2=thresheld for glitch test
      read(15,*) c1, c2, c3, c4, c5
      read(15,*) c1s, c2s, c3s, c4s, c5s, csampt
      read(15,*)  iflag1, idi,  iflagprt
      read(15,*)  ipage,amag
c  iglag1=0  analyze the first event only, otherwise, analyze all.
c  idi=1, then time series will be integrated before azimuth determination
c  otherwise, no integration is performed
c  iflagprt=0,  time series will not be written (to save i-o time)
      close(15)
c     c0 converts counts to cm/s.  approximately 9.62e-8
c ---  End  read parameters  ----
c ---  Compute normalization factors for recursive filter ----
      scale1=2./(1.+c1)
      scale1s=2./(1.+c1s)
c ---- End  ----
      open(14,file='i_qqt5')
      read(14,*)  alats,  alogs, azmcor
      read(14,'(a40)')  station
      close(14)
      call initinp(station)
c ----  read sequential data -------
      id1='Output from qqt5rt: ' // station(1:nbcha(station,40))
      call rdsmpl(1, xz(1), xn(1), xe(1), njunk, nmsec1,istat)
      call rdsmpl(1, xz(1), xn(1), xe(1), njunk, nmsec2,istat)
      call rdsmpl(-2,0,0,0, njunk, njunk,istat)
      dt=nmsec2-nmsec1
      dt=dt/1000.0
      if(dt.lt.0.0) dt=dt+1.0
      nt0=t0/dt
      nt0s=t0s/dt
      nampav=tampav/dt
      nazm=tazm/dt
      nampsav=tampsav/dt
      nlas=tlas/dt
      nsas=tsas/dt
      nvh=nazm
      ng=nazm/2
      goto 305
c ----  start detection --------------------------------------------------------
304   continue
305   continue
      open(16,file=tmpout)
      write(16,'(a40)')  station
c ------ Establish the baseline -------
      ic=0
      xzav=0.
      xnav=0.
      xeav=0.
      call rdsmpl(nt0,xz(1),xn(1),xe(1),ntime,nmsec,istat)
      if(istat.lt.nt0) then
        close(16)
        goto 304
      end if
      do l=1, nt0
      xzav=xzav+xz(l)
      xnav=xnav+xn(l)
      xeav=xeav+xe(l)
      end do
      xzav=xzav/float(nt0)
      xnav=xnav/float(nt0)
      xeav=xeav/float(nt0)
c --- go back to the beginning  --------------------
      call rdsmpl(-nt0, 0,0,0, njunk, njunk,istat)
      if(istat.gt.-nt0) then
        close (16)
        goto 304
      end if
c -----------------------------------
c ------ P pick -------
      i=1
300   continue
      if (i.gt.ndim) then
        close(16)
        goto 304
      end if
      call rdsmpl(1,xz(i),xn(i),xe(i),njunk,njunk,istat)
      if(istat.lt.1) then
	close(16)
        goto 304
      end if
      xz(i)=xz(i)-xzav
      xn(i)=xn(i)-xnav
      xe(i)=xe(i)-xeav
      if (i.eq.1)  then
      yz(i)=0.0
      yn(i)=0.0
      ye(i)=0.0
      dxz(i)=0.0
      e(i)=yz(i)**2+dxz(i)**2
      sav(i)=0.0
      alav(i)=0.0
      rat(i)=0.0
c e is "test function" for detection, sav is short term average
c alav=long-term average, rat=ratio
      else
      yz(i)=c1*yz(i-1)+(xz(i)-xz(i-1))*c0/scale1
      yn(i)=c1*yn(i-1)+(xn(i)-xn(i-1))*c0/scale1
      ye(i)=c1*ye(i-1)+(xe(i)-xe(i-1))*c0/scale1
c yz, yn, and ye are high-pass filtered traces
      dxz(i)=c2*c0*(xz(i)-xz(i-1))
      e(i)=yz(i)**2+dxz(i)**2
      sav(i)=sav(i-1)+c3*(e(i)-sav(i-1))
      alav(i)=alav(i-1)+c4*(e(i)-alav(i-1))
      rat(i)=sav(i)/alav(i)
      end if
      if (i.gt. nt0)  then
      if (rat(i).gt.c5.and.abs(yz(i)).ge.pthr) go to 350 
      endif
      i=i+1
      goto 300
350   continue
      write(16,*) 'P amp. at trigger', abs(yz(i))
      ip=i
      ipfb=i+ic
      write(16,*) 'sav, alav, rat, c5', sav(ip), alav(ip), rat(ip), c5
      write(16,*)  'event detected at'
      ptime=float(ipfb-1)*dt
      call tmstr_qqt5(ntime,nmsec,ptime,timest)
      id2=timest
      write(16,'(a8, f15.2,x,a25)')  ' ptime= ', ptime,timest
c  ---read "nread" data beyond ip to compute amplitude and azimuth -----
      nread=max(nampav, nazm,nt0s)
      call rdsmpl(nread,xz(ip+1),xn(ip+1),xe(ip+1),
     c     njunk,njunk,istat)
      if(istat.lt.nread) then
    	close(16)
 	goto 304
      end if
      do  l=ip+1, ip+nread
      xz(l)=xz(l)-xzav
      xn(l)=xn(l)-xnav
      xe(l)=xe(l)-xeav
      yz(l)=c1*yz(l-1)+(xz(l)-xz(l-1))*c0/scale1
      yn(l)=c1*yn(l-1)+(xn(l)-xn(l-1))*c0/scale1
      ye(l)=c1*ye(l-1)+(xe(l)-xe(l-1))*c0/scale1
      end do
c --Compute average P amp ------
      s=0.
      do k=ip+1, ip+nampav
      s=s+yz(k)**2
      end do
      s=s/float(nampav)
      s=sqrt(s)
      pamp=s
c --- compute tskip and tswindow
      s=s**(1./2.85)
      tskip=p1*pamp**0.25
      tswindow=min(tskip,tswdmax)
      nswindow=tswindow/dt
      write(16,*) 'pamp, tswindow, tskip',pamp,tswindow,tskip
      nskip=int(tskip/dt)
      write(16,'(i8,3x,a22)') nskip, 'points will be skipped' 
      do l=1, nazm
c     for azimuth determination, use data from 1 point before P
      xza(l)=yz(ip+l-2)-yz(ip-1)
      xna(l)=yn(ip+l-2)-yn(ip-1)
      xea(l)=ye(ip+l-2)-ye(ip-1)
      end do
c ---  comput average freq. to remove teleseismic event  ---
      call zerocr3(xza,dt,nazm,nzero,f)
      write(16,*) 'average frequency of p',  f, telf
      if(f.le.telf)  then
c      write(16,*) 'Probably teleseismic, no pick is made'
c      write(16,*) 'detection level 1'
      write(16,*) 'Probably teleseismic'
      write(16,*) 'detection level 1'
      ndetlev=1
      go to  315
      end if
c ---- Azimuth determination ------
      call azmdet1(xza,xna,xea,nazm,azm,aih,azmave,aihave,idi)
      azmave=azmave+azmcor
      write(16, *)  'Back Azimuth and Incidence Angle'
      write(16,'(2f10.2)')  azmave,  aihave
c --- compute average vertical and horizontal amplitudes for V/H test
      sv=0.
      sh=0.
      do k=ip+1, ip+nazm
      sv=sv+yz(k)**2
      sh=sh+yn(k)**2+ye(k)**2
      end do
      vhratio=sqrt(sv)/sqrt(sh)
      if(vhratio.gt.cf1)  then
      write(16,*) 'Vert./Horiz. criterion satisfied',vhratio,cf1
      else
      write(16,*) 'Vert./Horiz. criterion not satisfied',vhratio,cf1
      write(16,*) 'P pick is made any way'
      endif
c ---  glitch test -----
      sg1=0
      sg2=0
      do k=ip, ip+ng
      sg1=sg1+abs(xz(k))
      k2=k+ng
      sg2=sg2+abs(xz(k2))
      end do
      write(16,*)'glitch test', sg1, sg2, cf2
      if (sg1/sg2.gt.cf2)  then
      write(16,*) 'caution!, "P" could be a glitch' ,sg1/sg2,cf2
      end if
c --- compute average squared-amplitude just after p arrival --
c ---  this may be used as a reference level for S pick ----
      s=0.
      do k=ip+1, ip+nt0s
      s=s+0.333*(yz(k)**2+yn(k)**2+ye(k)**2)
      end do
      refsq=s/float(nt0s)
c ---- move the pointer backward to the point just after P pick time ---
      call rdsmpl(-nread,0,0,0,njunk,njunk,istat)
      if(-istat.lt.nread) then
	close(16)
	goto 304
      end if
c --- set rats(i)=0. up tp P
      yt(1)=0.
      dxt(1)=0.
      et(1)=0.
      savs(1)=0.
      alavs(1)=0.
      rats(1)=0.
c ---- Compute transverse component before P, this is for plotting purpose only ---
      do l=2, ip
      yt(l)=ye(l)*cos(d2r*azmave)-yn(l)*sin(d2r*azmave)
      dxt(l)=c2s*c0*(xz(l)-xz(l-1))
      et(l)=yt(l)**2+dxt(l)**2
c      savs(l)=savs(l-1)+c3s*(et(l)-savs(l-1))
      savs(l)=0.
c      alavs(l)=alavs(l-1)+c4s*(et(l)-alavs(l-1))
      alavs(l)=0.
c      rats(l)=savs(l)/refsq
c      rats(l)=savs(l)/alavs(l)
      rats(l)=0.
      end do
c   begin S pick ----
      i=ip+1
500   continue
      if(i.gt.ip+nswindow)  go to 375
      call rdsmpl(1,xz(i),xn(i),xe(i),njunk,njunk,istat)
      if(istat.lt.1) then
	close(16)
 	goto 304
      end if
      xz(i)=xz(i)-xzav
      xn(i)=xn(i)-xnav
      xe(i)=xe(i)-xeav
      yz(i)=c1s*yz(i-1)+(xz(i)-xz(i-1))*c0/scale1s
      yn(i)=c1s*yn(i-1)+(xn(i)-xn(i-1))*c0/scale1s
      ye(i)=c1s*ye(i-1)+(xe(i)-xe(i-1))*c0/scale1s
      yt(i)=ye(i)*cos(d2r*azmave)-yn(i)*sin(d2r*azmave)
      dxz(i)=c2*c0*(xz(i)-xz(i-1))
      e(i)=yz(i)**2+dxz(i)**2
      sav(i)=sav(i-1)+c3*(e(i)-sav(i-1))
      alav(i)=alav(i-1)+c4*(e(i)-alav(i-1))
      rat(i)=sav(i)/alav(i)
      dxt(i)=c2s*c0*(xz(i)-xz(i-1))
      et(i)=yt(i)**2+dxt(i)**2
      if(i.lt.ip+nlas+nsas)  then
      savs(i)=0.
      alavs(i)=0.
      rats(i)=0.
      else
      stemp=0.
      do l=1, nlas
      stemp=stemp+et(i+l-nlas-nsas)
      end do
      alavs(i)=stemp/float(nlas)
      stemp=0.
      do l=1, nsas
      stemp=stemp+et(i+l-nsas)
      end do
      savs(i)=stemp/float(nsas)
      rats(i)=savs(i)/alavs(i) 
      if (rats(i).gt.c5s) go to 550
      end if
      i=i+1
      go to 500
550   continue
      write(16,*) 'rats,  c5s,  yt(i)', rats(i),c5s,yt(i)
      write(16,*) 'detection level 2'
      ndetlev=2
      is=i
      isend=is
      go  to  571
375   write(16,*)  'S pick failed with ST/LT criterion'
      write(16,*)  'Try S pick with max amp. criterion'
c  try S pick with the max amp.---------------
      isend=ip+nswindow
      call maxmin (yt, ip+nswindow, ytmax, ytmin)
      write(16,*) 'ytmax',  ytmax
c      call maxmin (savs, ip+nswindow, savsmax, savsmin)
c      do l=ip+nsas+nlas+1, ip+nswindow
c      if(savs(l).gt.csampt*savsmax)  go to 570
      call maxmin (et, ip+nswindow, etmax, etmin)
      do l=ip+1, ip+nswindow
      if(et(l).gt.csampt*etmax)  go to 570
      end do
570   continue
      is1=l
c      do l=ip+nsas+nlas+1, ip+nswindow
c      if(savs(l).gt.0.8*csampt*savsmax)  go to 579
      do l=ip+1, ip+nswindow
      if(et(l).gt.0.8*csampt*etmax)  go to 579
      end do
579   continue
      is2=l
      write(16,*) 'st2, st1, delts',dt*float(is2),dt*float(is1),delts
      if(abs(dt*float(is1-is2)).gt.delts)  go to  585
      is=is2
      write(16,*)'S picked with Max. amp criterion,  could be spurious'
      write(16,*) 'detection level 0'
      ndetlev=0
571   continue
      isfb=is+ic
      write(16,*)  'S detected at'
c  ----- Determine average amplitude of S wave ----
      call rdsmpl(nampsav, xz(is+1), xn(is+1), xe(is+1), 
     c   njunk, njunk,istat)
      if(istat.lt.nampsav) then
	close(16)
	goto 304
      end if
      do  l=is+1, is+nampsav
      xn(l)=xn(l)-xnav
      xe(l)=xe(l)-xeav
      yn(l)=c1s*yn(l-1)+(xn(l)-xn(l-1))*c0/scale1s
      ye(l)=c1s*ye(l-1)+(xe(l)-xe(l-1))*c0/scale1s
      end do
      s=0.
      do k=is+1, is+nampsav
      s=s+(yn(k)+ye(k))**2
      end do
      s=s/float(nampsav)
      s=sqrt(s)
      stime=float(isfb-1)*dt
      samp=s
      write(16,'(a14,f15.2,e12.5)') 'stime and samp', stime,samp
c compute distance from s-p time, determine location and magnitude ------
      smp=stime-ptime
      dist=-0.69568+7.7091*smp+0.042316*smp**2-0.0002480*smp**3
      dist=dist-6.
      if (dist.le.0.)  dist=0.
      write(16,'(a9,f10.3,a3,1x,a6,f10.3,a2)')
     2 'S-P time=',smp,'sec','Dist=',dist,'km'
      amsw=alog10(samp)+aloga0(dist)+3.8
      ampw=alog10(pamp)+aloga0(dist)+4.4
      distd=dist/111.2
      call latlon (alats, alogs,distd,azmave, alate, aloge)
      ammax=max(ampw,amsw)
      write(16,'(a3,f10.3,1x,a3,f10.3)') 'MP=', ampw, 'MS=',amsw
      write(16,*)  'M=', ammax
      write(16,'(a5,f12.3,1x,a6,f12.3)')
     2 'Lat.=', alate,'Long.=', aloge
575   continue
c ------ read data through the end of skip  window ----- 
      call rdsmpl(-nampsav,0,0,0, njunk, njunk,istat)
      if(-istat.lt.nampsav) then
	close(16)
	goto 304
      end if	
      go  to  576
585   continue
      write(16,*)'S phase is ambiguous and not picked'
      write(16,*) 'detection level 3'
      ndetlev=3
576   continue
      do l=isend+1, ip+nskip
      call rdsmpl(1,xz(l),xn(l),xe(l),njunk,njunk,istat)
      if(istat.lt.1) then
	close(16)
	goto 304
      end if
      xz(l)=xz(l)-xzav
      xn(l)=xn(l)-xnav
      xe(l)=xe(l)-xeav
      yz(l)=c1s*yz(l-1)+(xz(l)-xz(l-1))*c0/scale1s
      yn(l)=c1s*yn(l-1)+(xn(l)-xn(l-1))*c0/scale1s
      ye(l)=c1s*ye(l-1)+(xe(l)-xe(l-1))*c0/scale1s
      yt(l)=ye(l)*cos(d2r*azmave)-yn(l)*sin(d2r*azmave)
      dxz(l)=c2*c0*(xz(l)-xz(l-1))
      e(l)=yz(l)**2+dxz(l)**2
      sav(l)=sav(l-1)+c3*(e(l)-sav(l-1))
      alav(l)=alav(l-1)+c4*(e(l)-alav(l-1))
      rat(l)=sav(l)/alav(l)
      dxt(l)=c2s*c0*(xz(l)-xz(l-1))
      et(l)=yt(l)**2+dxt(l)**2
      stemp=0.
      do k=1, nlas
      stemp=stemp+et(l+k-nlas-nsas)
      end do
      alavs(l)=stemp/float(nlas)
      stemp=0.
      do k=1, nsas
      stemp=stemp+et(l+k-nsas)
      end do
      savs(l)=stemp/float(nsas)
      rats(l)=savs(l)/alavs(l) 
      end do
      call  maxmin(rats,ip+nswindow,ratsmax, ratsmin)
      write(16,*) 'ratsmax,  c5s', ratsmax, c5s
c    compute average amplitude over the entire time window
      avvamp=0.
      do  l=ip+1, ip+nskip
      avvamp=avvamp+yz(l)**2+yn(l)**2+ye(l)**2
      end do
      avvamp=avvamp/float(nskip)
      avvamp=sqrt(avvamp)
      avvampind=alog10(avvamp)+6.0
      apxwa=1.41*2.8e7*avvamp/(2.*3.14*3.0)
      write(16,*) 'Average Amp.at site','(index ',avvampind,')'
      write(16,*)  'or  approx. WA in micron', apxwa
      write(16,*)
      if (iflagprt.ne.0)  then
      itotal=ip+nskip
      end if
c ---    go to the beginning  -----
      ic=ic+itotal
315   continue

      close(16)


      call system("cat tempmail >> activity.log")
c
c No paging on ndetlev 1 = teleseism, and
c   none    on ndetlev 3 = S not picked
c   and now on ndetlev 0 = max amplitude S pick
c
c Page only on ndetlev = 2 = good S pick
c
      if (ndetlev .eq. 2 ) then

      if (ipage .eq. 1 .and. ammax .ge. amag ) then
        call pageit(ntime,nmsec,ptime,
     2 alate,aloge,ammax,distd,smp,station)
      endif


      if ( ammax .ge. 3.5 ) then
	call system("/bin/mailx rt_gutenberg35list < tempmail")
      else if ((ammax .ge. 3.0) .and. (station(1:3) .eq. "PAS")) then
	call system("/bin/mailx rt_gutenberg35list < tempmail")
      endif

      if ((ammax .ge. 3.0) .and. (station(1:3) .eq. "PAS")) then
	call system("/bin/mailx rt_gutenbergpaslist < tempmail")
      endif

      endif

      if (iflag1.eq.0) then
        go to 370
      end if
      go  to 305

370   continue
      stop
      end
