/*  Routines in sdr_utils.c						*/
/*	@(#)sdr_utils.h	1.2 11/1/94 09:16:34	*/

#ifndef sdr_utils_H
#define sdr_utils_H

#include    "timedef.h"
#include    "sdr.h"

#ifdef __cplusplus
extern "C"
{
INT_TIME    decode_time_sdr (SDR_TIME);
SDR_TIME    encode_time_sdr (INT_TIME);
DATA_HDR    *decode_hdr_sdr (SDR_HDR *, int *);
char	    *asc_sdr_time (char *, SDR_TIME);
time_t	    unix_time_drm_sdr_time (SDR_TIME);
int	    read_blockettes (DATA_HDR *, char *);
BS	    *find_blockette (DATA_HDR *, int);
int	    write_blockettes (DATA_HDR *, char *);
int	    add_blockette (DATA_HDR *, char *, int, int);
int	    delete_blockette (DATA_HDR *, int);
void	    free_data_hdr(DATA_HDR *);
int	    eval_rate (int sample_rate_factor, int sample_rate_mult);
}
#else

INT_TIME    decode_time_sdr (SDR_TIME);
SDR_TIME    encode_time_sdr (INT_TIME);
DATA_HDR    *decode_hdr_sdr (SDR_HDR *, int *);
char	    *asc_sdr_time (char *, SDR_TIME);
time_t	    unix_time_drm_sdr_time (SDR_TIME);
int	    read_blockettes (DATA_HDR *, char *);
BS	    *find_blockette (DATA_HDR *, int);
int	    write_blockettes (DATA_HDR *, char *);
int	    add_blockette (DATA_HDR *, char *, int, int);
int	    delete_blockette (DATA_HDR *, int);
void	    free_data_hdr(DATA_HDR *);
int	    eval_rate (int sample_rate_factor, int sample_rate_mult);



#endif
#endif
