c/***********************************************************
c
cFile Name :
c     realmag.f
c
cProgrammer:
c	Phil Maechling
c
cDescription:
c 	This is the online version of the Hiroo's realmag program.
c
cCreation Date:
c	3 October 1995
c
c
cModification History:
c
c
cUsage Notes:
c Note that broad band is assigned = 0 strong motion = 1
c
c**********************************************************/
c
c  modified from real1.f
c  Aug.29, 1995  hiroo kanamori
c  program to compute magnitude etc real time
c  real-time mode using recursive filter
c  The velocity trace is filtered using
c  a mechanical instrument response with hf and ff.
c  difference equation is used for W-A response, and for vbb with dt=0.05 sec
c  the response could be underestimated by a few %.
c  computes time-stamped ML and ME computed for each tw-window and a default
c  distance of 100 km
c

    	
	subroutine realmag (
	2 nreset,
	2 itype,dt,
	2 f0,h0,gf,
	2 stacorml,stacoren,
	2 fwa,hwa,gfwa,
	2 ff,hf,
	2 tt0,tw,
	2 rxav,
	2 rywa,ryv,rya,ryen,rx,
	2 rml100,rme100,
	2 rsecs,rmsecs)
c
c ---  type=channel b = 0 or s = 1
c ---  dt = seconds per sample
c ---  f0, h0, gf are the instrument response 
c ---  stacorml=ML station correction, stacoren=station correction for energy
c ---- fwa, hwa, gfwa = W-A constants, usually 1.25, 0.8, 2800.
c ---- ff, hf =corner freq. and damping constant of filter
c ---- tt0 duration of data to be used for setting baseline
c ---- tw=duration of data for maximum amplitude search
c ---- tw is normally 30 sec to 1.5 min ---
c
c
c Define the calling parameters
c
      	
      integer itype
      real dt
      real f0,h0,gf
      real stacorml,stacoren
      real fwa,hwa,gfwa
      real ff,hf
      real tt0,tw
      real rxav	
      real rml100,rme100
      integer rsecs,rmsecs
      integer nreset
      integer nsec1,nmsec1,istat
      real dummy1,dummy2
      real rywa(3),ryv(3),rya(3),ryen(3),rx(3)


      parameter (ndimx=82000,ndim=1100, ndim2=8200)
      parameter(rho=2.5, velocity=3.0, cqr0=0.49710, anqr0=1.0322)
      parameter(akqr0=0.0035, rref=8.0, pi=3.141592)
      parameter(cen2a=1.96, cen2b=9.05)
      parameter (dist100=100.)


      dimension  x(ndimx)
      dimension  ywa(ndim)
      dimension  yv(ndim)
      dimension  ya(ndim)
      dimension  yen(ndim)
      dimension  uwa(ndim2)
      dimension  uv(ndim2)
      dimension  ua(ndim2)
      dimension  uen(ndim2)
c
c Start initial calculations
c

      amp0=qr1(rref,cqr0,anqr0,akqr0)
      amp=qr1(sqrt(10000.+rref**2),cqr0,anqr0,akqr0)
      amult=rho*velocity*4.*3.141592*rref**2*amp0**2/(4.*amp**2)
      amult=amult*1.e15

c ---------------------------------------------------------------------------
c ----  read data id and read data and write in a sequential format ---------
c ----   This is to simulate realtime situation -------
c -- get station coordinates and response and station corrections ---

      nt0=tt0/dt+0.1
      nw=tw/dt+0.1
      wf0dt=2.*pi*f0*dt
      wfwadt=2.*pi*fwa*dt
      wffdt=2.*pi*ff*dt
      c1w=1.+hwa*wfwadt
      c1f=1.+hf*wffdt
      c2f=1.+2.*hf*wffdt+wffdt**2
      c2w=1.+2.*hwa*wfwadt+wfwadt**2
      c5w=1.+hwa*wfwadt+(wfwadt**2)/3.
      c6w=2.-(wfwadt**2)/3.
      c7w=1.-hwa*wfwadt+(wfwadt**2)/3.
      ireset=0
c
c Pass the xav in and out of the program to save it's value during subroute
c   calls
c
      xav=rxav

360   continue

c ---- reset  -----
c ------ Establish the baseline -------
c -- Return point for error on socket read
c
c Check here for the reset flag
c
	if (nreset.eq.1) then
	goto 443
	else
	do l = 1,3
	ywa(l) = rywa(l)
	yv(l)  = ryv(l)
	ya(l)  = rya(l)
	yen(l) = ryen(l)
	x(l)   = rx(l)
	end do	
	goto 317
	endif 

443   continue
c
c One each reset baseline pass print out the values in use
c
c
c	write(*,*) 'f0,h0,gf',f0,h0,gf
c	write(*,*) 'stacorml,stacoren',stacorml,stacoren
c	write(*,*) 'fwa,hwa,gfwa', fwa,hwa,gfwa
c	write(*,*) 'ff,hf',ff,hf
c	write(*,*) 'tt0,tw',tt0, tw
c
444   continue

      ireset=ireset+1

      sav=0.
      s2av=0.


      do l=1, nt0

      call rdsmpl(1,dummy1,x(l),dummy2,nsec1,nmsec1,istat)
      if (istat.ne.1) then
	write(*,*) 'at setting baseline'
	write(*,*) 'error on rdsmpl - resetting'
	goto 444
      endif
	
      sav=sav+x(l)
      s2av=s2av+x(l)**2
      end do
c
c      do l=1, nt0
c      read(17,'(e12.5)', end=375)  x(l)
c      sav=sav+x(l)
c      s2av=s2av+x(l)**2
c      end do
c
      sav=sav/float(nt0)
      s2av=s2av/float(nt0)
      s2av=sqrt(abs(s2av-sav**2))

      if(abs(sav).ge.s2av)  then
        xav=sav
      endif

c      write(*,*) 'xav', xav

c ---  if the signal is large or if there is a glitch, baseline is not adjusted
c
c
c --- Now, go back to the beginning  of data --------------------

      call rdsmpl(-nt0,0,0,0,njunk,njunk,istat)
      if (istat .ne. -nt0) then
	write(*,*) 'at more backward to baseline samples'
	write(*,*) 'error on rdsmpl - resetting'
	goto 444
      endif

c      do l=1, nt0
c      backspace 17
c      end do
c -----------------------------------
c --- start conversion -----
c
335   continue
310   continue

      do  l=1, 3
      call rdsmpl(1,dummy1,xt,dummy2,nsec1,nmsec1,istat)
      if (istat.ne.1) then
        write(*,*) 'error on rdsmpl- resetting'
	goto 444
      endif
      ywa(l)=0.
      yv(l)=0.
      ya(l)=0.
      yen(l)=0.
      x(l)=xt-xav
      end do

317   continue

      do 500  ir=1, 1
      j=1
315   continue


      call rdsmpl(1,dummy1,xt,dummy2,nsec1,nmsec1,istat)
      if (istat.ne.1) then
        write(*,*) 'error on rdsmpl- resetting'
	goto 444
      endif

      x(4)=xt-xav
      dxdt=x(4)-x(3)
      d2xdt2=x(4)-2.*x(3)+x(2)

      if(itype.eq.0) then
c ---  for broadband ---
c ----  acceleration ------
         ya(4)=dxdt/(gf*dt)
c ----  velocity  -----------
c         yv(4)=x(4)/gf
	  yv(4)=((x(4)-2.*x(3)+x(2))/gf+2.*c1f*yv(3)-yv(2))/c2f
c ---  W-A response ----
         ywa(4)=(gfwa*dt*(x(4)-x(2))/(2.*gf)+c6w*ywa(3)
     2   -c7w*ywa(2))/c5w
c ---- energy ---
         yen(4)=yen(3)+yv(4)**2*dt
         else if (itype.eq.1)  then
c ----  for fba  -----
c ----    acceleration ------
         ya(4)=x(4)/gf
c ----  velocity ----
         yv(4)=(dt*dxdt/gf+2.*c1f*yv(3)-yv(2))/c2f
c ----- W-A response -----
         ywa(4)=(gfwa*x(4)*dt**2/gf+2.*c1w*ywa(3)-ywa(2))/c2w
c ---- energy ---
         yen(4)=yen(3)+yv(4)**2*dt
         else 
         write(*,*) 'type must be either b=0 or s=1'
         stop
      end if


        uwa(j)=ywa(4) 
        uv(j)=yv(4) 
        ua(j)=ya(4) 
        uen(j)=yen(4)

      do ki=1, 3
      x(ki)=x(ki+1)
      ya(ki)=ya(ki+1)
      yv(ki)=yv(ki+1)
      ywa(ki)=ywa(ki+1)
      yen(ki)=yen(ki+1)
      end do

        j=j+1
        if (j.gt.nw)  then
          call realsp(uwa,nw,wamax,kwamax,avawa,smrwa)
          call realsp(uv,nw,vmax,kvmax,avav,smrv)
          call realsp(ua,nw,amax,kamax,avaa,smra)
          enmax=uen(nw)
	  wamax=abs(wamax)

c if wamax of enmax is very small, it is set at a water level

	if (wamax .le. 1.0e-4) wamax = 0.0001
 	if (enmax .le. 1.0e-12) enmax=1.0e-12

c -------------
          aml100=alog10(wamax*10.)+aloga0(dist100)+stacorml
          energy=amult*3.0*enmax*stacoren
          ame100=(alog10(energy)-cen2b)/cen2a
	  yen(3) = 0.
c
c
c
c          write(26,'(f10.0, 2f10.2)') time, aml100, ame100
c
          go to 500
        end if
      go to 315 
500   continue
c   --- End conversion  ---
      rxav = xav	
      rml100 = aml100
      rme100 = ame100
      rsecs  = nsec1
      rmsecs = nmsec1
c
c Copy the values into the return parameters
c

      do l = 1,3
       rywa(l) = ywa(l)
       ryv(l)  = yv(l)
       rya(l)  = ya(l)
       ryen(l) = yen(l)
       rx(l)   = x(l)
      end do	



      return

      end

      subroutine realsp(x,n,xmax,kmax,av,smr)
c     subroutine for real1.f
c     looks for the absolute maximum, and computes
c     sigma/average of abs(x) for diagnostics of glitches
c     if smr>>1 (e.g. smr>3), the signal is likely to be a glitch
c     6/28/1995  h. kanamori
      dimension x(*)
      call maxmin2(x,n,xmax,xmin,kmax,kmin)
      if (abs(xmax).ge.abs(xmin)) then
      xmax=abs(xmax)
      kmax=kmax
      else
      xmax=abs(xmin)
      kmax=kmin
      end if
      s1=0.
      s2=0.
      do i=1, n
      s1=s1+abs(x(i))
      s2=s2+abs(x(i)**2)
      end do
      av=s1/float(n)
      sigma=sqrt(s2/float(n)-av**2)
      smr=sigma/av
      return
      end
