/***********************************************************

File Name :
	plotmag.c

Programmer:
	Phil Maechling

Description:
	Plotting routines which calls realmag to calculate
 	constant magnitudes

Creation Date:
	3 October 1995

Modification History:


Usage Notes:


*********************************************************/
#include <stdio.h>
#include <string.h>
#include "syserr.h"
#include "terradefs.h"

#define REALMAG_CONFIG_FILE "/home/phil/da/realmag/realmag.cfg"
#define INPUT_DATA_FILE     "/home/phil/da/realmag/180isa"

int main(int argc,char* argv[])
{

  FILE* fp;
  char inline[120];
  char sta[6];         /* Station name */
  char  comp[2];       /* component name */
  char  itype[2];      /* instrument type s or b */
  int   instr_type;    /* integer instrument type */
  float sps;           /* seconds per sample */
  float f0,h0,gf;      /* instrument response */
  float stacorml;      /* ml station correction */
  float stacoren;      /* station correction for energy mag */
  float ff,hf;         /* corner frequency and damping constant */
  float fwa,hwa,gfwa;  /* wa constants usually 1.24 0.8 2800.0 */
  float tt0;           /* duration of data for setting baseline */
  float tw;            /* duration of data for max amplitude search */
  float rml100,rme100; /* returned magnitude values */
  long rsecs,rmsecs;  /* returned time values */
  float fdummy;       /* dummy time between read time and mark */
  int status;
  int station_not_found;
  int res,res1;
  int plotting;
  char timestr[30];
  int nrepeat;
  int pcount;
  int ireset;
  float rxav;

  if (argc < 3)
  {
    printf("Usage: plotmag stationname component\n");
    exit(FAILURE); 
  }

  fp = fopen(REALMAG_CONFIG_FILE,"r");
  if (fp == NULL)
  {
    fatalsyserr("Error opening realmag configuration file\n");
  }

  station_not_found = TRUE;

  while(station_not_found)
  {
    fgets(inline,sizeof(inline),fp);

    /* Test for end of file found */

    if (feof(fp))
    {
      fclose(fp);
      printf("Station %s : Component : %s   not found in realmag \
	configuration file\n",argv[1],argv[2]);
      return(FAILURE);
    }

    /* test for comment */
    if ( (status = strncmp(inline,"#",1)) == 0)
    {
      continue;
    }

    status = sscanf(inline,"%s %s %s %f %f %f %f %f %f %f %f %f %f %f %f %f %d",
                        sta,comp,itype,&sps,
                        &f0,&h0,&gf,
                        &stacorml,&stacoren,
                        &fwa,&hwa,&gfwa,
                        &ff,&hf,
                        &tt0,&tw,&nrepeat);



    if (status != 17)
    {
      printf("Error scanning realmag configuration file\n");
      continue;
    }
    else 
    {
      res = strncasecmp(sta,argv[1],3);
      res1 = strncasecmp(comp,argv[2],1);
      if ( (res == 0) && (res1 == 0) )
      {
        station_not_found = FALSE;
        continue;
      }
    }
  } /* end of while config not found */

  fclose(fp);

  if ( (status = strncasecmp(itype,"b",1)) == 0)
  {
    instr_type = 0;
  }
  else if ( (status = strncasecmp(itype,"s",1)) == 0)
  {
   instr_type = 1;
  }
  else
  {
    printf("Unknown instrument type : %s \n",itype);
    return(FAILURE);
  }

  plotting = TRUE;


  initinp_(sta);
  pcount = 0;
  rxav = 0; /* set the initial xav to zero */
  ireset = TRUE;

  while(plotting)
  {
    realmag_(&ireset,
	     &instr_type,&sps,
  	     &f0,&h0,&gf,
	     &stacorml,&stacoren,
             &fwa,&hwa,&gfwa,
	     &ff,&hf,
             &tt0,&tw,
	     &rxav,
	     &rml100,&rme100,&rsecs,&rmsecs);

    fdummy = 0.0;
    tmstr_qqt5_(&rsecs,&rmsecs,&fdummy,timestr);

    fprintf(stdout,"Current Ml : %4.2f Current Me : %4.2f Time : %s \n",rml100,rme100,timestr);

    ++pcount;

    if(pcount >= nrepeat)
    {
      pcount = 0;
      ireset = TRUE;
    }
    else
    {
      ireset = FALSE;
    } 

    fflush(stdout);
  }

  exit(SUCCESS);
}
