c ----------------------------------------------------------------------
	SUBROUTINE DIST_AZ (plat1, plon1, plat2, plon2, dist, az)

c	Given two points figure the distance between them and the azimuth
c	from point 2 to point 1

	PARAMETER (R = 6371.0,		!radius of the earth
	1	 FAC = 0.01745329)	!degrees to radians

c --	convert to radians (don't convert (contaminate) original values)

	  DLAT = (plat1 - plat2) * FAC

	  olat = plat2 * FAC
	  olon = plon2 * FAC

	  rlon = plon1 * FAC

	  Y = R * DLAT
	  X = (RLON - OLON) * R * COS((DLAT/2.0)+OLAT)

	dist = sqrt(x*x + y*y)

	az = atan2d (x, y)
	if (az .lt. 0.0) az = az + 360.0

	return
	end


C ----------------------------------------------------------------------
	SUBROUTINE WHERE (EQLAT, EQLON, IRES)

C	Given the lat and lon of a point write strings containing the
c	nearest geographic location for each group as designated by the
c	first character in the listing ('grp').
c
c NOTE: Sign of the longitude is significant! We assume negative longitude is
c	in the western hemisphere.
c
c	Ex. "  14 miles southwest of PALMDALE"
c	    "  30 miles N     of LOS ANGELES"
c	    "  36 miles Nwest of PASADENA"
c	Information about towns is in an ASCII data file equated with the
c	logical name DCK$TOWN. The format is (i2, 1x, f6.3, 1x, f8.3, 1x, a50)
c	as follows:
c
c	iiXff.fffXffff.fffXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa
c	 1 34.223 -118.448 PANORAMA CITY          
c	01 34.143 -114.287 PARKER                   
c	 2 35.742 -120.350 PARKFIELD                
c	 3 34.145 -118.140 Site of some past important earthquake
c	 4 32.65  -114.65  PLT (blast)              
c	etc.
c
c	The leading number assigns each town to a group.  The closest town in 
c	EACH group is output, therefore there are as many lines output as there 
c	are groups.  This way you can be assured of not only finding the 
c	closest town on the list but also the closest MAJOR city, the closest
c	quarry site or whatever you choose.
c
c	Our current scheme is:
c	Group 1		smaller towns, landmarks
c	Group 2		large towns
c	Group 3		Pasadena
c	Group 4		quarry sites
c	Group 5		notable earthquakes or sequences
c
c	IRES returns the number of groups (and output strings) if successful
c
c	The DCK$TOWN is only read the first time this routine is called
c	When it is read the data is stored in arrays for future use
c
c MODIFIED: 12-FEB-1992 DDG - to pass location description strings through
c	common /WHERE_OUT/ so they can be used by the program, don't write
c	anything out from subroutine, let the calling program do it
c
c MODIFIED:  7-JUL-1992 DDG - make abreviated azimuth descripton "NNW", etc. 
c	rather then "NORTH-NORTHWEST"

c
c .. arrays holding all the town data (is read in the first time)
	parameter 	(MAX_TOWNS = 400)
	character*50 	ctown(max_towns)
	real 		slat(max_towns), slon(max_towns)
	integer 	ngroup(max_towns)
	integer 	ntowns

c .. arrays holding index of closest 'town' in each group 

	include 'where.inc'

	integer 	iclosest(max_grps)	!index (number) of closest town
	real 		fmin(max_grps)		!dist to closest town for this group

	integer ngrps

	character*15 cdir(16)			! compass points
	data cdir /'N',
	1	'NNE',
	1	'NE ',
	1	'ENE',
	1	'E  ',
	1	'ESE',
	1	'SE ',
	1	'SSE',
	1	'S  ',
	1	'SSW',
	1	'SW ',
	1	'WSW',
	1	'W  ',
	1	'WNW',
	1	'NW ',
	1	'NNW'/

	do i = 1, max_grps
	 cwhere(i) = ' '
	 fmin(i) = 10000.0		!max out the minimums
	end do

c ****** read in town data, if this is the first call to subroutine

	if (ngrps .eq. 0) then

c .. open 'DCK$TOWN' (it is a logical)
	  iunit = 10
	  ier = 10
	  open (iunit, 
	1	file='/home/rtem/where/town.dat', 
	1	status='old', 
	1	err=910)

	  ntowns = 0
	  ngrps = 0

c .. read loop
  10	  ntowns = ntowns + 1
	  ier = 100 + ntowns
	  read (iunit, 100, iostat=lstat, err=910, end=200) 
	1     ngroup(ntowns), slat(ntowns), slon(ntowns), ctown(ntowns)
 100	  format (i2, 1x, f6.3, 1x, f8.3, 1x, a50)

	  if (ntowns .gt. max_towns) then	!check for array overflow
	    write(*,*) ' ** WHERE WARNING: number of towns exceeds ' 
	    goto 200
	  end if

	  if (ngroup(ntowns) .gt. max_grps) then   !check for array overflow
	    write(*,*) ' ** WHERE WARNING: number of town groups exceeds ', 
	1	max_grps ,' (proceeding..)'
	    goto 200
	  end if

	  ngrps = max(ngrps, ngroup(ntowns))	!find biggest group number
	  goto 10		!end of read loop

 200	  close (iunit)

	  ntowns = ntowns - 1		!correct increment count of EOF

	end if

c ......................................................................
c .. find the closest town
c .. test to see if eac town is closer than the previous closest for the group
c	(first cut checking is done in degrees, this is approximate but
c	 is quicker than calculating km. The real distance in km will be
c	 calculated only for the closest town in each group)

	do i = 1, ntowns			!for each town

	  dlat = abs(EQLAT - slat(i))	!lat difference
	  if (dlat .gt. fmin(ngroup(i))) goto 390 !farther than previous in group

	  dlon = abs(EQLON - slon(i))	!lon difference (west lon is neg!)
	  if (dlon .gt. fmin(ngroup(i))) goto 390 !farther than previous

	  ddist = sqrt(dlat*dlat + dlon*dlon) 	!'diagonal' dist in degrees
	  if (ddist .gt. fmin(ngroup(i))) goto 390 !farther than previous

c .. this town is closer
	  iclosest(ngroup(i)) = i		!reset test values to latest
	  fmin(ngroup(i)) = ddist		!set min to new minimum
 390	end do

c ......................................................................
c .. all out of towns, output the results

 	do i = 1, ngrps			!output a line for each group
	  call dist_az (eqlat, eqlon, 
	1	slat(iclosest(i)), slon(iclosest(i)), dist, az)

	  idist = int(dist * 0.6214)	!convert to integer miles

c .. figure out which of sixteen directions quake is in from town
c	each hexant is 22.5 deg., hexant #1 is north and they are arranged
c	clockwise from there

	  taz = az + 11.25
	  if (taz .ge. 360.) taz = taz - 360.	

	  i_hexant = int(taz/22.5) + 1

c .. put the string in the common array
	  ier = 200 + i
	  write (cwhere(i), 110, iostat=lstat, err=910) idist, 
	1	cdir(i_hexant), ctown(iclosest(i)), char(0)
  110	  format (i4, ' mi. ', a3, ' of ', a50,a1)

c	  write (lunit, 120, iostat=lstat, err=910) cwhere(i)
c  120	  format (a)

	end do			!end of output loop
	
	ires = ngrps		!return a good ires

 	return

c --- ERROR path

 910	type*,'ERROR --  WHERE --- ', ier, ires, lstat
	ires = - ier
	return
	end

C ----------------------------------------------------------------------
	SUBROUTINE WHERE_FAULT (EQLAT, EQLON, IRES)

c	DDG - 19-AUG-1992
C	Given the lat and lon of a point write a string containing the
c	nearest fault
c
c	Ex. "  14 miles southwest of San Jacinto fault"
c
c	Information about faults is in ASCII .GEO files as created by SIFT
c	File is defined by logical DCK$FAULT
c
c NOTE: The .GEO files use positive longitudes therefore we must take abs() of 
c	longitude here. Another testiment to Menlo's provinciality.

c .. arrays holding all the town data (is read in the first time)
	PARAMETER 	(MAX_FAULTS = 500)
	PARAMETER	(MAX_PTS    = 50000)

	STRUCTURE/FAULT_DATA/
	  character*50 	CNAME 		!name of each fault
	  integer	istart		!start index in slat/slon array
	  integer	npts		!number of point/pairs for each fault
	END STRUCTURE

	real 		slat(max_pts), slon(max_pts)	!points

	RECORD/FAULT_DATA/	FLT(MAX_FAULTS)

	integer 	nflt		!number of faults

	include 'where.inc'

	character*15 cdir(16)			! compass points
	data cdir /'N',
	1	'NNE',
	1	'NE ',
	1	'ENE',
	1	'E  ',
	1	'ESE',
	1	'SE ',
	1	'SSE',
	1	'S  ',
	1	'SSW',
	1	'SW ',
	1	'WSW',
	1	'W  ',
	1	'WNW',
	1	'NW ',
	1	'NNW'/

c ****** read in fault data, if this is the first call to subroutine

	if (nflt .eq. 0) then 	!don't read in faults if it was done before

c .. open 'DCK$FAULT' (it is a logical)
	  iunit = 21
	  ier = 10
	  open (iunit, 
	1	file='fault.dat', 
	1	status='old', 
	1	err=910, 
	1	blank='ZERO')			!see NOTE: below

c NOTE: .GEO file format has lat/lon pairs with spaces in place of leading 
c	zeros in the decimal portion. EX: "325823118 106" therefore, we must
c	interpret spaces as zeros.

	  nflt     = 0		!number of faults read in
	  npts_tot = 0		!total number of point/pairs for all faults

c .. read loop
  10	continue
	  npts = 0		!total number of point/pairs for this fault
	  nflt = nflt + 1
	  flt(nflt).istart = npts_tot + 1 

	  if (nflt .gt. max_faults) then	!check for array overflow
	    type*,' ** WHERE_FAULT WARNING: number of faults exceeds ', 
	1	max_faults ,' (proceeding..)'
	    goto 300
	  end if

	  ier = 1000 + nflt

c	... read fault name line
	  read (iunit, 100, iostat=lstat, err=910, end=300) 
	1	flt(nflt).cname
 100	  format (78x, a50)

c There are up to 6 point/pairs per line. A block of data for a fault is 
c terminated by " 0   0  0   0" in any position in the line.
c There may be more than one block of points for a given fault but that makes no
c difference here so I ignore it.

  20	continue
c	... read next 6 fault point-pairs
	  read  (iunit, 200, iostat=lstat, err=910, end=300) 
	1     (slat(j), slon(j), j=npts_tot+1, npts_tot+6)
 200	  format (6(f6.4, f7.4))

	  do i = npts_tot+1, npts_tot+6		!check for zeros
	    if (slat(i) .gt. 0.0 .and. slon(i) .gt. 0.0) then
	      npts = npts + 1
	      npts_tot = npts_tot + 1
	      flt(nflt).npts = npts

	    else
	      goto 10			!end of data for this fault, get another
	    end if
	      
	  end do

	  goto 20			!get another line

c ... end of read loop
 300	  continue

	  close (iunit)

	  nflt = nflt - 1		!correct increment count of EOF

	end if

c ......................................................................
c .. find the closest point
c .. test to see if each point is closer than the previous closest 
c	(first cut checking is done in degrees, this is approximate but
c	 is quicker than calculating km. The real distance in km will be
c	 calculated only at the end)

	fmin = 10000.0

	do i = 1, nflt			!for each fault

	  do k = flt(i).istart, flt(i).istart + flt(i).npts - 1

	    dlat = abs(EQLAT - slat(k))		!lat difference

	    dlon = abs(abs(EQLON) - slon(k))	!lon difference 

	    ddist = sqrt(dlat*dlat + dlon*dlon) !'diagonal' dist in degrees

	    if (ddist .lt. fmin) then		!closer than previous closest
	      klose_flt = i		!remember close fault and point
	      klose_pt  = k
	      fmin = ddist		!set min to new minimum
	    end if

	  end do
 	end do

c ......................................................................
c .. all done, output the results

	  call dist_az (eqlat, abs(eqlon), 
	1	slat(klose_pt), slon(klose_pt), 
	1	dist, az)

	  idist = int(dist * 0.6214)	!convert from km to integer miles

c .. figure out which of sixteen directions quake is in from town
c	each hexant is 22.5 deg., hexant #1 is north and they are arranged
c	clockwise from there

	  taz = az + 11.25
	  if (taz .ge. 360.) taz = taz - 360.	

	  i_hexant = int(taz/22.5) + 1

c .. put the string into "cfault"
	  ier = 200 
	  write (cfault, 110, iostat=lstat, err=910) idist, 
	1	cdir(i_hexant), flt(klose_flt).cname
  110	  format (i4, ' mi. ', a3, ' of the ', a50)

 	return

c --- ERROR path

 910	type*,'ERROR --  WHERE_FAULT --- ', ier, ires, lstat
	ires = - ier
	return
	end

c
c
c
	SUBROUTINE get_where_grps(str_array)
	
	include 'where.inc'
c
c This copies the contents of chwhere and cfault into a variable
c and returns.  
c
	character*80 str_array(max_grps)

	do i = 1, max_grps 
	  str_array(i) =  cwhere(i)//char(0)
	end do	
	end
c
c
c
	SUBROUTINE get_where_fault(str)
	
	include 'where.inc'
c
c This copies the contents of chwhere and cfault into a variable
c and returns.  
c
	character*80 str

	str =  cfault//char(0)
        return
	end
