#include <stdio.h>
#include <errno.h>
#include <stdlib.h> /* for exit */

void syserr(char *msg)
{
  extern int errno, sys_nerr;
  extern char *sys_errlist[];

  fprintf(stdout,"ERROR: %s ( errno: %d",msg,errno);
  if (errno > 0 && errno < sys_nerr)
    fprintf(stdout,"; Description: %s)\n",sys_errlist[errno]);
  else
    fprintf(stdout,")\n");  
  fflush(stdout);
}

void fatalsyserr(char *msg)
{
  extern int errno, sys_nerr;
  extern char *sys_errlist[];

  fprintf(stdout,"FATAL ERROR: %s ( errno: %d",msg,errno);
  if (errno > 0 && errno < sys_nerr)
    fprintf(stdout,"; Description: %s)\n",sys_errlist[errno]);
  else
    fprintf(stdout,")\n");  
  fflush(stdout);
  exit(-1);
}

