/***********************************************************

File Name :
	qpager.h

Programmer:
	Phil Maechling

Description:
	These define the routines that create and disassmble the
	qpager paging messages.

Limitations or Warnings:


Creation Date:
	26 June 1995

Modification History:

**********************************************************/
#ifndef qpager_H
#define qpager_H

#define LENGTH_OF_PAGE 80
#define SIZE_OF_QFIELD 12

struct qpager_data_type
{
char   message_type[SIZE_OF_QFIELD];    /* A2 "E " */
int    event_id;                        /* Event id number */ 
char   data_source[SIZE_OF_QFIELD];     /* A2 "PA" is pasadena */
int    event_version;
int    year;                            /* gmt */
int    month;
int    day;
int    hour;
int    minute;
float  second;
float  latitude;
float  longitude;
float  depth;
float  magnitude;
int    stations_in_location;
int    phases_in_location;
float  closest_station;
float  time_rms;
float  horizontal_rms;
float  vertical_rms;
float  az_gap;
char   mag_type[SIZE_OF_QFIELD];
int    stations_in_mag;
float  magnitude_rms;
char   method_of_location[SIZE_OF_QFIELD];
char   checksum[SIZE_OF_QFIELD];
};


#ifdef __cplusplus
extern "C"
{
int qevent_to_computer_page(struct qpager_data_type *qevent,char *comppage);

int qevent_to_belt_page(struct qpager_data_type *qevent,
                                       char *beltpage,
                                       char *source);
}
#else

int qevent_to_computer_page(struct qpager_data_type *qevent,char *comppage);

int qevent_to_belt_page(struct qpager_data_type *qevent,
                                       char *beltpage,
                                       char *source);
 
#endif
#endif
