#include <time.h>
#include <string.h>
#include <stdio.h>
#include "epackets.h"
#include <time.h>
#include <sunmath.h>
#include "cbasics.h"
#include "qpager.h"


void pageit_(long *secs, long *msec, float *dsecs,float *latit, 
	float *longit, float *magmax, 
	float *distd, float *smp,char *station)
{
	char  stationname[40];

	ldiv_t          ldivtemp;
	struct tm       etime;
	long            temp, nsecs, nmsec;
	float           ndsecs;
        int    		intsecs;
	struct	qpager_data_type qevent;
	static int event_num = 20;
        FILE *fp;

	char beltpage[LENGTH_OF_PAGE +1];

        char comppage[LENGTH_OF_PAGE +1];

	char logpage[200];

  	int res;
	int i = -1;

	/* Null terminate the fortran string */

	i = -1;
	strncpy(stationname, station, 10);
	while (stationname[++i] != ' ');
	stationname[i] = 0;

	/* First convert the time to year month day hr min sec. */

	nsecs = *secs;
	nmsec = *msec;
	ndsecs = *dsecs;
	temp = irint(ndsecs);
	nsecs += temp;
	nmsec += irint((float) (ndsecs - temp) * 1000.0);
	ldivtemp = ldiv(nmsec, 1000);
	nmsec = ldivtemp.rem;
	nsecs += ldivtemp.quot;
	if (nmsec < 0) {
		nmsec += 1000;
		nsecs--;
	}

	/* Subtract travel time from P pick time */
       
        nsecs = nsecs - (1.366 * (*smp));

	zero_qevent(&qevent);

        ymdhms_(&nsecs,&nmsec,&qevent.year,&qevent.month,&qevent.day,
                         &qevent.hour,&qevent.minute,&intsecs);
  
        qevent.second = (float) intsecs;

	/* Add in the latitude , longitude, and set depth fixed at 6.0 km */

	qevent.latitude = *latit;
	qevent.longitude = *longit;
        qevent.depth = 6.0;


	/* Magnitude */

	qevent.magnitude = *magmax;


	/* Set some of the string data */

        memcpy(qevent.message_type,"Event",strlen("Event"));

        memcpy(qevent.data_source,"Pasadena",strlen("Pasadena"));

	memcpy(qevent.mag_type,"Me",strlen("Me")); 
						/* Ml is type E */

	memcpy(qevent.method_of_location,"TERRAscope",strlen("TERRAscope")); 
						/* type T is an TERRAscope */


	/* Set some of the information we have */

	qevent.stations_in_location = 1;

	qevent.phases_in_location = 3;

	qevent.closest_station = *distd;

	qevent.stations_in_mag = 1;

	qevent.event_version = 1;
 
	/* Get event ID number */

	qevent.event_id = get_event_id();

	/* convert to beltpage */

	qevent_to_belt_page(&qevent,beltpage,"G");

	printf("Beltpage     : %s \n",beltpage);

        fp = fopen("beltpage.dat","w");
        if (fp == NULL)
        {
          printf("Error opening belt page file");
          return;
        }
 
        fprintf(fp,"%s",beltpage);
        fclose(fp);
 
        send_pages("gutenberg_belt","beltpage.dat");

        /* Send computer page */

	qevent_to_computer_page(&qevent,comppage);

        fp = fopen("comppage.dat","w");
        if (fp == NULL)
        {
          printf("Error opening computer page file");
          return;
        }
 
        fprintf(fp,"%s",comppage);
        fclose(fp);

        send_pages("gutenberg_comp","comppage.dat");

	return;

}
