/*	
   File : moment.c

   Purpose : Find standard deviation for points. Recipe
              copied from Numerical recipes in C.

   Programmer : Phil Maechling

   Last Modified : 27 July 1993
 
 */

#include <math.h>

void moment(float data[],int n,float* ave,float* sdev)

/* Given an array data[0..(n-1)], this routine returns its mean
  ave, average deviation adev, standard deviation, variance var,
  skewness skew, and kurtosis curt 
*/

{
  int j;
  float s,p,adev,svar;
  

  if(n<=1) 
  {
    printf("N must be at least 2\n");
  }

  s=0.0;

  for(j=0;j<=(n-1);j++)
  {
    s += data[j];
  }

  *ave=s/n;

  adev=(svar)=0.0;

  for(j=0;j<=(n-1);j++)
  {
    adev += fabs(s=data[j] - (*ave));
    svar += (p=s*s);
  } 

  svar /= (n-1);
  *sdev = sqrt(svar);

}
