/***********************************************************

File Name :
	locks.h

Programmer:
	Phil Maechling

Description:
	This implements a file locking scheme which uses
	file creates as a atomic action.

	The pid of the process that has the lock is put into
	the lock file, which then can be checked for and crashed
	programs will free up the lock.

Limitations or Warnings:
	Don't delete /tmp/* when this is in use, as you may delete
	the lock file, and allow multiples access to a resource.
	

Creation Date:

	1995 July 11 

Modification History:

**********************************************************/
#ifndef locks_H
#define locks_H

#ifdef __cplusplus
extern "C"
{
int lock(char *name);
void unlock(char *name);
}
#else
int lock(char *name);
void unlock(char *name);
#endif
#endif
