/***********************************************************

File Name :
	locks.c

Programmer:
	Phil Maechling

Description:
	This implements a file locking scheme which uses
	file creates as a atomic action.

	The pid of the process that has the lock is put into
	the lock file, which then can be checked for and crashed
	programs will free up the lock.

Limitations or Warnings:
	Don't delete /tmp/* when this is in use, as you may delete
	the lock file, and allow multiples access to a resource.
	

Creation Date:

	1995 July 11 

Modification History:

**********************************************************/


#define LOCKDIR "/tmp/"
#define MAXTRIES 10
#define NAPTIME 2

#include <stdio.h>
#include <fcntl.h>
#include <ctype.h>
#include <errno.h>

int lock(char *name)
{

  char *path,*lockpath();
  int lock_fd,tries,trylock,lock_pid;
  extern int errno;
  char lock_contents[10];

  path = lockpath(name);

  tries = 0;

  if ((lock_fd = open(path,O_RDONLY)) != -1)
  {
    if (read(lock_fd,lock_contents,10) > 0)
    {
      lock_pid = atoi(lock_contents);
      if (lock_pid)
      {
        if (kill(lock_pid,0))
        {
          unlink(path); 
        }
      }     
    }
    close(lock_fd);
  }

  trylock = 1;

  while (trylock == 1)
  {
    if ((lock_fd = open(path, O_WRONLY | O_CREAT | 
      O_EXCL, 0444)) != -1)
    {
      sprintf(lock_contents, "%d", getpid());
      write(lock_fd,lock_contents,
        strlen(lock_contents));
      close(lock_fd);
      trylock=0;
    }
    else
    {
      if(++tries >= MAXTRIES)
      {
        trylock = -1;
      }
      sleep(NAPTIME);
    }
  }
  return(trylock);
}

void unlock(char *name)
{
  char *lockpath();

  if (unlink(lockpath(name)) == -1)
    syserr("unlock");
}


static char *lockpath(char *name)
{
  static char path[20];
  char *strcat();

  strcpy(path,LOCKDIR);
  return(strcat(path,name));
}
