/***********************************************************

File Name :
	eventid.c

Programmer:
	Phil Maechling

Description:
	This is the event id routine. All programs on terra10 that
	need an event id should call this routine to get an event
	id.

Limitations or Warnings:
	This uses a lock file in /tmp. If  you delete the file in /tmp
	you can allow collisions between processes trying to get 
	the event id file.

Creation Date:
	11 July 1995

Modification History:

**********************************************************/
#include <stdio.h>
#include "syserr.h"

#define EVENT_ID_PATH "/home/rtem/event_ids/event_ids.dat"
#define EVENT_ID_FILE "event_ids.dat"
#define DEFAULT_ID 10000000

static default_id = DEFAULT_ID;
extern int lock(char *file);
extern int unlock(char *file);
extern void syserr(char *msg);

int get_event_id()
{

  FILE *fp;
  int res;
  int e_id;


  res = lock(EVENT_ID_FILE);

  if (res < 0)
  {
    printf("Couldn't get lock for event id file.\n");
    printf("Delivering default id in event id. \n");
    --default_id;
    return(default_id);
  }

  fp = fopen(EVENT_ID_PATH,"r");

  if (fp == NULL)
  {
    syserr("Error opening event_id file for reading.\n");
    printf("Delivering default id in event id. \n");
    --default_id;
    unlock(EVENT_ID_FILE);
    return(default_id);
  } 

  res = fscanf(fp,"%d",&e_id);

  if (res !=1)
  {
    printf("Error scanning id from event_id file.\n");
    printf("Delivering default id in event id. \n");
    fclose(fp);
    unlock(EVENT_ID_FILE);
    --default_id;
    return(default_id);
  }

  fclose(fp);

  ++e_id;

  fp = fopen(EVENT_ID_PATH,"w");
  if (fp == NULL)
  {
    syserr("Error opening event_id file for writing.\n");
    printf("Delivering default id in event id. \n");
    --default_id;
    unlock(EVENT_ID_FILE);
    return(default_id);
  } 

  fprintf(fp,"%d\n",(e_id));

  fclose(fp);

  unlock(EVENT_ID_FILE);

  --e_id;

  return(e_id);
}


