/***********************************************************

File Name :
	utils.C

Programmer:
	Phil Maechling

Description:
	These are utility routines used by the main k2rt program.
	converter.

Creation Date:
	26 January 1996

Modification History:


Usage Notes:

**********************************************************/
#include <iostream.h>
#include <stdlib.h>
#include <ctype.h>    // for islower isupper 

#include "basics.h"


char *syntax[] = {
"    [-d ] [-c k2net.cfg] station",
"",
"    where:",
"       -d            Debugging messages will be output.",
"       -c k2net.cfg  Specify the name of the K2 network config file.",
"       station       Station name.",
"",
NULL };


void print_syntax(char *cmd)
{
  cout << endl;
  cout << cmd;
  for (int i = 0; syntax[i] != NULL; i++)
  {
    cout << syntax[i] << endl;
  }
}

char *upcase(char* str)
{
    unsigned char c;
    char *string;

    string = str;
    while (c = *str) *(str++) = islower(c) ? toupper(c) : c;
    return (string);
}
