/***********************************************************

File Name :
	tc.h

Programmer:
	Phil Maechling

Description:
	This is class declaration for the main packet conversion
	class used in the K2 to Q512 converter program.

	The file name is an abbreviation Top Class, the
	top class in the K2 to Q512 conversion program.

Creation Date:
	26 January 1996

Modification History:


Usage Notes:


**********************************************************/
#ifndef tc_H
#define tc_H

#include "kpr.h"
#include "ikpp.h"
#include "config.h"
#include "sockctrl.h"


class K2toQ512
{

public:

  K2toQ512();
  ~K2toQ512();
  convert_K2_to_Q512();

private:  


  CPacket rxpacket;
  CCommControl k2_port;
  int k2_port_open;


  QPacket qpacket;
  SocketControl dl_port;
  int q512_port_open;

  K2_Port_Reader port_reader;
  Incoming_K2_Packet_Processor packet_processor;

  void set_termination_flag(int sig);  
  void wrapup();
  int terminate_program;

  struct k2_port_definition_type   k2_port_def;
  struct q512_port_definition_type q512_port_def;
};

#endif
