/***********************************************************

File Name :
	tc.C

Programmer:
	Phil Maechling

Description:
	This is class definition for the main packet conversion
	class used in the K2 to Q512 converter program.

	The file name is an abbreviation Top Class, that is
	the main class for K2 to Q512 conversion.

Creation Date:
	26 January 1996

Modification History:


Usage Notes:


**********************************************************/
#include <iostream.h>
#include <signal.h>

#include "basics.h"
#include "tc.h"
#include "utils.h"
#include "packet.h"
#include "commctrl.h"
#include "config.h"

extern int debug;


//**********************************************************************
// Constructor
//**********************************************************************

K2toQ512::K2toQ512()
{

  /* Here all the other object constructors will be called */
  /* Manually install the signal handler */


//  signal(SIGINT,(void *)set_termination_flag);
//  signal(SIGTERM,(void *)set_termination_flag);

  cout << "Performing K2 to Q512 converter class construction" << endl;
  debug = FALSE;
  terminate_program = FALSE;



 
  /* Call scanner and read initialization file */
 
  //fill_out_K2_port_description(k2_port);

  // Initialize K2 port

  cout << "Initializing Input K2 Port" << endl;
  strcpy(k2_port_def.port_name,"/dev/sts/ttyD42");
  k2_port_def.baud_rate = 19200;
 
  int res = k2_port.OpenPort(k2_port_def.port_name,k2_port_def.baud_rate);
  if (res == SUCCESS)
  {
    k2_port_open = TRUE;
  }


 

 // Initialize Q512 Port

  cout << "Initializing Output Q512 Port " << endl;

  // Fill_out_q512_port_description(q512_port_config);

  strcpy(q512_port_def.host_name,"terra10.gps.caltech.edu");
  q512_port_def.port_number = 35002;

 
  res = dl_port.OpenSocket(q512_port_def.host_name,
		           q512_port_def.port_number);

  if (res == SUCCESS)
  {
    q512_port_open = TRUE;
  }


  // Initialize the acknowledgement counter

  
  k2_port.ZeroAckCounter();



}

//**********************************************************************
// Destructor
//**********************************************************************

K2toQ512::~K2toQ512()
{

  // Close port on way out //

  k2_port.ClosePort();

  wrapup();

}

//**********************************************************************
// Process Incoming K2 Packets
//**********************************************************************

K2toQ512::convert_K2_to_Q512()
{

  if ( (k2_port_open) && (q512_port_open))
  {
    while(terminate_program == FALSE)
    {
     port_reader.get_next_valid_packet(k2_port,rxpacket);
     packet_processor.process_k2_packet(k2_port,rxpacket,dl_port,qpacket);
    }
  }

  return(TRUE);
}



//**********************************************************************
// Utility Routine called from constructor
//**********************************************************************

void K2toQ512::set_termination_flag(int sig)
{
//  signal(sig,set_termination_flag);
//  terminate_program = TRUE;
}


//**********************************************************************
// Utility routine called from destructor
//**********************************************************************

void K2toQ512::wrapup()
{

  cout << "Performing k2rt shutdown procedures " << endl;
}
